/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.settings;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.gravitee.rest.api.model.annotations.ParameterKey;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.settings.AbstractCommonSettingsEntity;
import io.gravitee.rest.api.model.settings.Analytics;
import io.gravitee.rest.api.model.settings.Api;
import io.gravitee.rest.api.model.settings.ApiQualityMetrics;
import io.gravitee.rest.api.model.settings.ApiReview;
import io.gravitee.rest.api.model.settings.Company;
import io.gravitee.rest.api.model.settings.Dashboards;
import io.gravitee.rest.api.model.settings.Documentation;
import io.gravitee.rest.api.model.settings.OpenAPIDocViewer;
import io.gravitee.rest.api.model.settings.PlanSettings;
import io.gravitee.rest.api.model.settings.Portal;
import io.gravitee.rest.api.model.settings.PortalApplicationSettings;
import io.gravitee.rest.api.model.settings.PortalAuthentication;
import io.gravitee.rest.api.model.settings.PortalNext;
import io.gravitee.rest.api.model.settings.PortalReCaptcha;
import io.gravitee.rest.api.model.settings.PortalScheduler;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;

public class PortalSettingsEntity
extends AbstractCommonSettingsEntity {
    private Analytics analytics;
    private Api api;
    private ApiQualityMetrics apiQualityMetrics;
    private ApiReview apiReview;
    private PortalApplicationSettings application;
    private PortalAuthentication authentication;
    private Company company;
    private PortalCors cors;
    private Documentation documentation;
    private OpenAPIDocViewer openAPIDocViewer;
    private PlanSettings plan;
    @Valid
    private Portal portal;
    @Valid
    private PortalNext portalNext = new PortalNext();
    private PortalReCaptcha reCaptcha;
    private PortalScheduler scheduler;
    private Dashboards dashboards;

    public PortalSettingsEntity() {
        this.analytics = new Analytics();
        this.api = new Api();
        this.apiQualityMetrics = new ApiQualityMetrics();
        this.apiReview = new ApiReview();
        this.application = new PortalApplicationSettings();
        this.authentication = new PortalAuthentication();
        this.company = new Company();
        this.cors = new PortalCors();
        this.documentation = new Documentation();
        this.openAPIDocViewer = new OpenAPIDocViewer();
        this.plan = new PlanSettings();
        this.portal = new Portal();
        this.reCaptcha = new PortalReCaptcha();
        this.scheduler = new PortalScheduler();
        this.dashboards = new Dashboards();
    }

    public Analytics getAnalytics() {
        return this.analytics;
    }

    public void setAnalytics(Analytics analytics) {
        this.analytics = analytics;
    }

    public Api getApi() {
        return this.api;
    }

    public void setApi(Api api) {
        this.api = api;
    }

    public ApiQualityMetrics getApiQualityMetrics() {
        return this.apiQualityMetrics;
    }

    public void setApiQualityMetrics(ApiQualityMetrics apiQualityMetrics) {
        this.apiQualityMetrics = apiQualityMetrics;
    }

    public ApiReview getApiReview() {
        return this.apiReview;
    }

    public void setApiReview(ApiReview apiReview) {
        this.apiReview = apiReview;
    }

    public PortalApplicationSettings getApplication() {
        return this.application;
    }

    public void setApplication(PortalApplicationSettings application) {
        this.application = application;
    }

    public PortalAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(PortalAuthentication authentication) {
        this.authentication = authentication;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public PortalCors getCors() {
        return this.cors;
    }

    public void setCors(PortalCors cors) {
        this.cors = cors;
    }

    public Documentation getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(Documentation documentation) {
        this.documentation = documentation;
    }

    public OpenAPIDocViewer getOpenAPIDocViewer() {
        return this.openAPIDocViewer;
    }

    public void setOpenAPIDocViewer(OpenAPIDocViewer openAPIDocViewer) {
        this.openAPIDocViewer = openAPIDocViewer;
    }

    public PlanSettings getPlan() {
        return this.plan;
    }

    public void setPlan(PlanSettings plan) {
        this.plan = plan;
    }

    public Portal getPortal() {
        return this.portal;
    }

    public void setPortal(Portal portal) {
        this.portal = portal;
    }

    public PortalReCaptcha getReCaptcha() {
        return this.reCaptcha;
    }

    public void setReCaptcha(PortalReCaptcha reCaptcha) {
        this.reCaptcha = reCaptcha;
    }

    public PortalScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(PortalScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Dashboards getDashboards() {
        return this.dashboards;
    }

    public void setDashboards(Dashboards dashboards) {
        this.dashboards = dashboards;
    }

    @Generated
    public PortalNext getPortalNext() {
        return this.portalNext;
    }

    @Generated
    public void setPortalNext(PortalNext portalNext) {
        this.portalNext = portalNext;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PortalCors {
        @ParameterKey(value=Key.PORTAL_HTTP_CORS_ALLOW_ORIGIN)
        private List<String> allowOrigin;
        @ParameterKey(value=Key.PORTAL_HTTP_CORS_ALLOW_HEADERS)
        private List<String> allowHeaders;
        @ParameterKey(value=Key.PORTAL_HTTP_CORS_ALLOW_METHODS)
        private List<String> allowMethods;
        @ParameterKey(value=Key.PORTAL_HTTP_CORS_EXPOSED_HEADERS)
        private List<String> exposedHeaders;
        @ParameterKey(value=Key.PORTAL_HTTP_CORS_MAX_AGE)
        private Integer maxAge;

        public List<String> getAllowOrigin() {
            return this.allowOrigin;
        }

        public void setAllowOrigin(List<String> allowOrigin) {
            this.allowOrigin = allowOrigin;
        }

        public List<String> getAllowHeaders() {
            return this.allowHeaders;
        }

        public void setAllowHeaders(List<String> allowHeaders) {
            this.allowHeaders = allowHeaders;
        }

        public List<String> getAllowMethods() {
            return this.allowMethods;
        }

        public void setAllowMethods(List<String> allowMethods) {
            this.allowMethods = allowMethods;
        }

        public List<String> getExposedHeaders() {
            return this.exposedHeaders;
        }

        public void setExposedHeaders(List<String> exposedHeaders) {
            this.exposedHeaders = exposedHeaders;
        }

        public Integer getMaxAge() {
            return this.maxAge;
        }

        public void setMaxAge(Integer maxAge) {
            this.maxAge = maxAge;
        }
    }
}

