/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.v4.api;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.FlowMode;
import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.rest.api.sanitizer.HtmlSanitizer;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(name="NewApiEntityV4")
public class NewApiEntity {
    @NotBlank
    @NotEmpty(message="API's name must not be empty")
    @Schema(description="API's name. Duplicate names can exists.", example="My Api")
    private @NotBlank @NotEmpty(message="API's name must not be empty") String name;
    @NotBlank
    @Schema(description="Api's version. It's a simple string only used in the portal.", example="v1.0")
    private String apiVersion;
    @NotNull
    @Schema(description="API's gravitee definition version")
    private DefinitionVersion definitionVersion = DefinitionVersion.V4;
    @NotNull
    @Schema(description="API's type", example="async")
    private ApiType type;
    @NotBlank
    @Schema(description="API's description. A short description of your API.", example="I can use a hundred characters to describe this API.")
    private String description;
    @Schema(description="The list of sharding tags associated with this API.", example="public, private")
    private Set<@NotBlank String> tags;
    @NotNull
    @Valid
    @Schema(description="A list of listeners used to describe our you api could be reached.")
    private @NotNull @Valid List<@NotNull Listener> listeners;
    @NotNull
    @Valid
    @Schema(description="A list of endpoint describing the endpoints to contact.")
    private List<EndpointGroup> endpointGroups;
    @Schema(description="API's flow mode.", example="BEST_MATCH")
    private FlowMode flowMode;
    @Valid
    @Schema(description="A list of flows containing the policies configuration.")
    private List<Flow> flows;
    @Schema(description="API's groups. Used to add team in your API.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<@NotBlank String> groups;

    public void setName(String name) {
        this.name = HtmlSanitizer.sanitize(name);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    @NotNull
    @Generated
    public DefinitionVersion getDefinitionVersion() {
        return this.definitionVersion;
    }

    @NotNull
    @Generated
    public ApiType getType() {
        return this.type;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<@NotBlank String> getTags() {
        return this.tags;
    }

    @NotNull
    @Generated
    public @NotNull List<@NotNull Listener> getListeners() {
        return this.listeners;
    }

    @NotNull
    @Generated
    public List<EndpointGroup> getEndpointGroups() {
        return this.endpointGroups;
    }

    @Generated
    public FlowMode getFlowMode() {
        return this.flowMode;
    }

    @Generated
    public List<Flow> getFlows() {
        return this.flows;
    }

    @Generated
    public Set<@NotBlank String> getGroups() {
        return this.groups;
    }

    @Generated
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Generated
    public void setDefinitionVersion(@NotNull DefinitionVersion definitionVersion) {
        this.definitionVersion = definitionVersion;
    }

    @Generated
    public void setType(@NotNull ApiType type) {
        this.type = type;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setTags(Set<@NotBlank String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setListeners(@NotNull @NotNull List<@NotNull Listener> listeners) {
        this.listeners = listeners;
    }

    @Generated
    public void setEndpointGroups(@NotNull List<EndpointGroup> endpointGroups) {
        this.endpointGroups = endpointGroups;
    }

    @Generated
    public void setFlowMode(FlowMode flowMode) {
        this.flowMode = flowMode;
    }

    @Generated
    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    @Generated
    public void setGroups(Set<@NotBlank String> groups) {
        this.groups = groups;
    }

    @Generated
    public String toString() {
        return "NewApiEntity(name=" + this.getName() + ", apiVersion=" + this.getApiVersion() + ", definitionVersion=" + this.getDefinitionVersion() + ", type=" + this.getType() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ", listeners=" + this.getListeners() + ", endpointGroups=" + this.getEndpointGroups() + ", flowMode=" + this.getFlowMode() + ", flows=" + this.getFlows() + ", groups=" + this.getGroups() + ")";
    }
}

