/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.v4.plan;

import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import lombok.Generated;

@Schema(enumAsRef=true, name="PlanSecurityTypeV4")
public enum PlanSecurityType {
    KEY_LESS("key-less"),
    API_KEY("api-key"),
    OAUTH2("oauth2"),
    JWT("jwt"),
    SUBSCRIPTION("subscription");

    private static final Map<String, PlanSecurityType> maps;
    private final String label;

    public static PlanSecurityType valueOfLabel(String label) {
        if (label != null) {
            PlanSecurityType planSecurityType = maps.get(label);
            if (planSecurityType == null) {
                try {
                    planSecurityType = PlanSecurityType.valueOf(label);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return planSecurityType;
        }
        return null;
    }

    @JsonValue
    public String getLabel() {
        return this.label;
    }

    @Generated
    private PlanSecurityType(String label) {
        this.label = label;
    }

    static {
        maps = Map.of(PlanSecurityType.KEY_LESS.label, KEY_LESS, PlanSecurityType.API_KEY.label, API_KEY, PlanSecurityType.OAUTH2.label, OAUTH2, PlanSecurityType.JWT.label, JWT, PlanSecurityType.SUBSCRIPTION.label, SUBSCRIPTION);
    }
}

