/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.configuration.identity.am;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderType;
import io.gravitee.rest.api.model.configuration.identity.SocialIdentityProviderEntity;
import java.util.List;
import java.util.Map;

public class AMIdentityProviderEntity
extends SocialIdentityProviderEntity {
    private static final String AUTHORIZATION_URL = "/oauth/authorize";
    private static final String TOKEN_URL = "/oauth/token";
    private static final String LOGOUT_URL = "/logout?target_url=";
    private static final String TOKEN_INTROSPECTION_URL = "/oauth/introspect";
    private static final String USER_INFO_URL = "/oidc/userinfo";
    private static final String ACCESS_TOKEN_PROPERTY = "access_token";
    private static final String AUTHORIZATION_HEADER = "Bearer %s";
    @JsonIgnore
    private String discoveryEndpoint;
    private List<String> scopes;
    private String color;
    @JsonIgnore
    private final String serverUrl;
    @JsonIgnore
    private Map<String, String> userProfileMapping;

    public AMIdentityProviderEntity(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Override
    public IdentityProviderType getType() {
        return IdentityProviderType.GRAVITEEIO_AM;
    }

    public String getDiscoveryEndpoint() {
        return this.discoveryEndpoint;
    }

    public void setDiscoveryEndpoint(String discoveryEndpoint) {
        this.discoveryEndpoint = discoveryEndpoint;
    }

    @Override
    public String getTokenEndpoint() {
        return this.serverUrl + TOKEN_URL;
    }

    @Override
    public String getAuthorizationEndpoint() {
        return this.serverUrl + AUTHORIZATION_URL;
    }

    @Override
    public String getUserLogoutEndpoint() {
        return this.serverUrl + LOGOUT_URL;
    }

    @Override
    public String getUserInfoEndpoint() {
        return this.serverUrl + USER_INFO_URL;
    }

    @Override
    public String getTokenIntrospectionEndpoint() {
        return this.serverUrl + TOKEN_INTROSPECTION_URL;
    }

    @Override
    public List<String> getRequiredUrlParams() {
        return null;
    }

    @Override
    public List<String> getOptionalUrlParams() {
        return null;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    @Override
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    public String getDisplay() {
        return null;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @Override
    public String getColor() {
        return this.color;
    }

    @Override
    public Map<String, String> getUserProfileMapping() {
        return this.userProfileMapping;
    }

    public void setUserProfileMapping(Map<String, String> userProfileMapping) {
        this.userProfileMapping = userProfileMapping;
    }
}

