/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.api;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.ExecutionMode;
import io.gravitee.definition.model.FlowMode;
import io.gravitee.definition.model.Properties;
import io.gravitee.definition.model.Property;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.definition.model.services.Services;
import io.gravitee.rest.api.model.DeploymentRequired;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.api.ApiEntrypointEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.search.Indexable;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;

@JsonFilter(value="apiMembershipTypeFilter")
public class ApiEntity
implements Indexable {
    @Schema(description="API's uuid.", example="00f8c9e7-78fc-4907-b8c9-e778fc790750")
    private String id;
    @Schema(description="API's crossId. Identifies API across environments.", example="df83b2a4-cc3e-3f80-9f0d-c138c106c076")
    private String crossId;
    @Schema(description="ID of the environment where the API is in.", example="DEFAULT", accessMode=Schema.AccessMode.READ_ONLY)
    private String environmentId;
    @Schema(description="API's name. Duplicate names can exists.", example="My Api")
    private String name;
    @Schema(description="API's version. It's a simple string only used in the portal.", example="v1.0")
    private String version;
    @Schema(description="API's description. A short description of your API.", example="I can use a hundred characters to describe this API.")
    private String description;
    @Schema(description="API's execution mode. Define if the execution mode should use v3 or jupiter mode.", example="v3")
    @DeploymentRequired
    @JsonProperty(value="execution_mode")
    private ExecutionMode executionMode;
    @Schema(description="API's groups. Used to add team in your API.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<String> groups;
    @JsonProperty(value="context_path")
    @Schema(description="API's context path.", example="/my-awesome-api")
    private String contextPath;
    @NotNull
    @DeploymentRequired
    @JsonProperty(value="proxy", required=true)
    @Schema(description="API's definition.")
    private Proxy proxy;
    @DeploymentRequired
    @JsonProperty(value="flow_mode")
    @Schema(description="API's flow mode.", example="BEST_MATCH")
    private FlowMode flowMode;
    @DeploymentRequired
    @JsonProperty(value="paths")
    @Schema(description="a map where you can associate a path to a configuration (the policies configuration)")
    private Map<String, List<Rule>> paths = new HashMap<String, List<Rule>>();
    @DeploymentRequired
    @JsonProperty(value="flows")
    @Schema(description="a list of flows (the policies configuration)")
    private List<Flow> flows = new ArrayList<Flow>();
    @DeploymentRequired
    @JsonProperty(value="plans")
    @Schema(description="a list of plans with flows (the policies configuration)")
    private Set<PlanEntity> plans = new HashSet<PlanEntity>();
    @DeploymentRequired
    @JsonProperty(value="gravitee")
    @Schema(description="API's gravitee definition version")
    private String graviteeDefinitionVersion;
    @JsonProperty(value="deployed_at")
    @Schema(description="The last date (as timestamp) when the API was deployed.", example="1581256457163")
    private Date deployedAt;
    @JsonProperty(value="created_at")
    @Schema(description="The date (as a timestamp) when the API was created.", example="1581256457163")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @Schema(description="The last date (as a timestamp) when the API was updated.", example="1581256457163")
    private Date updatedAt;
    @Schema(description="The visibility of the API regarding the portal.", example="PUBLIC")
    private Visibility visibility;
    @Schema(description="The status of the API regarding the gateway.", example="STARTED")
    private Lifecycle.State state;
    @JsonProperty(value="owner")
    @Schema(description="The user with role PRIMARY_OWNER on this API.")
    private PrimaryOwnerEntity primaryOwner;
    @DeploymentRequired
    @JsonProperty(value="properties")
    @Schema(description="A dictionary (could be dynamic) of properties available in the API context.")
    private Properties properties;
    @DeploymentRequired
    @JsonProperty(value="services")
    @Schema(description="The configuration of API services like the dynamic properties, the endpoint discovery or the healthcheck.")
    private Services services;
    @DeploymentRequired
    @Schema(description="the list of sharding tags associated with this API.", example="public, private")
    private Set<String> tags;
    @Schema(description="the API logo encoded in base64")
    private String picture;
    @JsonProperty(value="picture_url")
    @Schema(description="the API logo url.", example="https://gravitee.mycompany.com/management/apis/6c530064-0b2c-4004-9300-640b2ce0047b/picture")
    private String pictureUrl;
    @DeploymentRequired
    @JsonProperty(value="resources")
    @Schema(description="The list of API resources used by policies like cache resources or oauth2")
    private List<Resource> resources = new ArrayList<Resource>();
    @Schema(description="the list of categories associated with this API", example="Product, Customer, Misc")
    private Set<String> categories;
    @Schema(description="the free list of labels associated with this API", example="json, read_only, awesome")
    private List<String> labels;
    @DeploymentRequired
    @JsonProperty(value="path_mappings")
    @Schema(description="A list of paths used to aggregate data in analytics", example="/products/:productId, /products/:productId/media")
    private Set<String> pathMappings = new HashSet<String>();
    @JsonIgnore
    private Map<String, Object> metadata = new HashMap<String, Object>();
    @DeploymentRequired
    @JsonProperty(value="response_templates")
    @Schema(description="A map that allows you to configure the output of a request based on the event throws by the gateway. Example : Quota exceeded, api-ky is missing, ...")
    private Map<String, Map<String, ResponseTemplate>> responseTemplates;
    @JsonProperty(value="lifecycle_state")
    private ApiLifecycleState lifecycleState;
    @JsonProperty(value="workflow_state")
    private WorkflowState workflowState;
    @JsonProperty(value="disable_membership_notifications")
    private boolean disableMembershipNotifications;
    private List<ApiEntrypointEntity> entrypoints;
    @Schema(description="the API background encoded in base64")
    private String background;
    @JsonProperty(value="background_url")
    @Schema(description="the API background url.", example="https://gravitee.mycompany.com/management/apis/6c530064-0b2c-4004-9300-640b2ce0047b/background")
    private String backgroundUrl;
    @JsonIgnore
    private String referenceType;
    @JsonIgnore
    private String referenceId;

    @JsonIgnore
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @JsonSetter(value="properties")
    public void setPropertyList(List<Property> properties) {
        this.properties = new Properties();
        this.properties.setProperties(properties);
    }

    @JsonGetter(value="properties")
    public List<Property> getPropertyList() {
        if (this.properties != null) {
            return this.properties.getProperties();
        }
        return Collections.emptyList();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getCrossId() {
        return this.crossId;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    @NotNull
    public Proxy getProxy() {
        return this.proxy;
    }

    public FlowMode getFlowMode() {
        return this.flowMode;
    }

    public Map<String, List<Rule>> getPaths() {
        return this.paths;
    }

    public List<Flow> getFlows() {
        return this.flows;
    }

    public Set<PlanEntity> getPlans() {
        return this.plans;
    }

    public String getGraviteeDefinitionVersion() {
        return this.graviteeDefinitionVersion;
    }

    public Date getDeployedAt() {
        return this.deployedAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public Lifecycle.State getState() {
        return this.state;
    }

    public PrimaryOwnerEntity getPrimaryOwner() {
        return this.primaryOwner;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Services getServices() {
        return this.services;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public String getPicture() {
        return this.picture;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public Set<String> getPathMappings() {
        return this.pathMappings;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Map<String, Map<String, ResponseTemplate>> getResponseTemplates() {
        return this.responseTemplates;
    }

    public ApiLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }

    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    public List<ApiEntrypointEntity> getEntrypoints() {
        return this.entrypoints;
    }

    public String getBackground() {
        return this.background;
    }

    public String getBackgroundUrl() {
        return this.backgroundUrl;
    }

    @Override
    public String getReferenceType() {
        return this.referenceType;
    }

    @Override
    public String getReferenceId() {
        return this.referenceId;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="execution_mode")
    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @JsonProperty(value="context_path")
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @JsonProperty(value="proxy", required=true)
    public void setProxy(@NotNull Proxy proxy) {
        this.proxy = proxy;
    }

    @JsonProperty(value="flow_mode")
    public void setFlowMode(FlowMode flowMode) {
        this.flowMode = flowMode;
    }

    @JsonProperty(value="paths")
    public void setPaths(Map<String, List<Rule>> paths) {
        this.paths = paths;
    }

    @JsonProperty(value="flows")
    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    @JsonProperty(value="plans")
    public void setPlans(Set<PlanEntity> plans) {
        this.plans = plans;
    }

    @JsonProperty(value="gravitee")
    public void setGraviteeDefinitionVersion(String graviteeDefinitionVersion) {
        this.graviteeDefinitionVersion = graviteeDefinitionVersion;
    }

    @JsonProperty(value="deployed_at")
    public void setDeployedAt(Date deployedAt) {
        this.deployedAt = deployedAt;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void setState(Lifecycle.State state) {
        this.state = state;
    }

    @JsonProperty(value="owner")
    public void setPrimaryOwner(PrimaryOwnerEntity primaryOwner) {
        this.primaryOwner = primaryOwner;
    }

    @JsonProperty(value="services")
    public void setServices(Services services) {
        this.services = services;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    @JsonProperty(value="picture_url")
    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    @JsonProperty(value="resources")
    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public void setCategories(Set<String> categories) {
        this.categories = categories;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @JsonProperty(value="path_mappings")
    public void setPathMappings(Set<String> pathMappings) {
        this.pathMappings = pathMappings;
    }

    @JsonIgnore
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="response_templates")
    public void setResponseTemplates(Map<String, Map<String, ResponseTemplate>> responseTemplates) {
        this.responseTemplates = responseTemplates;
    }

    @JsonProperty(value="lifecycle_state")
    public void setLifecycleState(ApiLifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    @JsonProperty(value="workflow_state")
    public void setWorkflowState(WorkflowState workflowState) {
        this.workflowState = workflowState;
    }

    @JsonProperty(value="disable_membership_notifications")
    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    public void setEntrypoints(List<ApiEntrypointEntity> entrypoints) {
        this.entrypoints = entrypoints;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    @JsonProperty(value="background_url")
    public void setBackgroundUrl(String backgroundUrl) {
        this.backgroundUrl = backgroundUrl;
    }

    @Override
    @JsonIgnore
    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    @Override
    @JsonIgnore
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public String toString() {
        return "ApiEntity(id=" + this.getId() + ", crossId=" + this.getCrossId() + ", environmentId=" + this.getEnvironmentId() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", executionMode=" + this.getExecutionMode() + ", groups=" + this.getGroups() + ", contextPath=" + this.getContextPath() + ", proxy=" + this.getProxy() + ", flowMode=" + this.getFlowMode() + ", paths=" + this.getPaths() + ", flows=" + this.getFlows() + ", plans=" + this.getPlans() + ", graviteeDefinitionVersion=" + this.getGraviteeDefinitionVersion() + ", deployedAt=" + this.getDeployedAt() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", visibility=" + this.getVisibility() + ", state=" + this.getState() + ", primaryOwner=" + this.getPrimaryOwner() + ", properties=" + this.getProperties() + ", services=" + this.getServices() + ", tags=" + this.getTags() + ", picture=" + this.getPicture() + ", pictureUrl=" + this.getPictureUrl() + ", resources=" + this.getResources() + ", categories=" + this.getCategories() + ", labels=" + this.getLabels() + ", pathMappings=" + this.getPathMappings() + ", metadata=" + this.getMetadata() + ", responseTemplates=" + this.getResponseTemplates() + ", lifecycleState=" + this.getLifecycleState() + ", workflowState=" + this.getWorkflowState() + ", disableMembershipNotifications=" + this.isDisableMembershipNotifications() + ", entrypoints=" + this.getEntrypoints() + ", background=" + this.getBackground() + ", backgroundUrl=" + this.getBackgroundUrl() + ", referenceType=" + this.getReferenceType() + ", referenceId=" + this.getReferenceId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiEntity)) {
            return false;
        }
        ApiEntity other = (ApiEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

