/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.rest.api.model.ApiKeyMode;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

public class NewApplicationEntity {
    private static final PolicyFactory HTML_SANITIZER = new HtmlPolicyBuilder().toFactory();
    @NotNull(message="Application's name must not be null")
    @NotEmpty(message="Application's name must not be empty")
    @Schema(description="Application's name. Duplicate names can exists.", example="My App")
    private @NotNull(message="Application's name must not be null") @NotEmpty(message="Application's name must not be empty") String name;
    @NotNull(message="Application's description must not be null")
    @Schema(description="Application's description. A short description of your App.", example="I can use a hundred characters to describe this App.")
    private @NotNull(message="Application's description must not be null") String description;
    @Schema(description="Domain used by the application, if relevant", example="https://my-app.com")
    private String domain;
    private ApplicationSettings settings;
    @Deprecated
    @Schema(description="a string to describe the type of your app.", example="iOS")
    private String type;
    @Deprecated
    private String clientId;
    @Schema(description="Application groups. Used to add teams to your application.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<String> groups;
    private String picture;
    private String background;
    @JsonProperty(value="api_key_mode")
    @Schema(description="The API key mode used for this application.")
    private ApiKeyMode apiKeyMode;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = HTML_SANITIZER.sanitize(description);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = HTML_SANITIZER.sanitize(name);
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public ApplicationSettings getSettings() {
        return this.settings;
    }

    public void setSettings(ApplicationSettings settings) {
        this.settings = settings;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public ApiKeyMode getApiKeyMode() {
        return this.apiKeyMode;
    }

    public void setApiKeyMode(ApiKeyMode apiKeyMode) {
        this.apiKeyMode = apiKeyMode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Application{");
        sb.append("description='").append(this.description).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", groups='").append(this.groups).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

