/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.rest.api.model.ApiKeyMode;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.Set;

public class ApplicationEntity {
    @Schema(description="Application's uuid.", example="00f8c9e7-78fc-4907-b8c9-e778fc790750")
    private String id;
    @Schema(description="Application's name. Duplicate names can exists.", example="My App")
    private String name;
    @Schema(description="Application's description. A short description of your App.", example="I can use a hundred characters to describe this App.")
    private String description;
    @Schema(description="Domain used by the application, if relevant", example="https://my-app.com")
    private String domain;
    @Schema(description="Application groups. Used to add teams to your application.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<String> groups;
    @Schema(description="if the app is ACTIVE or ARCHIVED.", example="ACTIVE")
    private String status;
    @Schema(description="a string to describe the type of your app.", example="iOS")
    private String type;
    private String picture;
    @JsonProperty(value="created_at")
    @Schema(description="The date (as a timestamp) when the application was created.", example="1581256457163")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @Schema(description="The last date (as a timestamp) when the application was updated.", example="1581256457163")
    private Date updatedAt;
    @JsonProperty(value="owner")
    @Schema(description="The user with role PRIMARY_OWNER on this API.")
    private PrimaryOwnerEntity primaryOwner;
    @JsonProperty(value="settings")
    private ApplicationSettings settings;
    @JsonProperty(value="disable_membership_notifications")
    private boolean disableMembershipNotifications;
    @JsonProperty(value="api_key_mode")
    @Schema(description="The API key mode used for this application.")
    private ApiKeyMode apiKeyMode;
    private String background;

    public boolean hasApiKeySharedMode() {
        return this.apiKeyMode == ApiKeyMode.SHARED;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDomain() {
        return this.domain;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public String getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public String getPicture() {
        return this.picture;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public PrimaryOwnerEntity getPrimaryOwner() {
        return this.primaryOwner;
    }

    public ApplicationSettings getSettings() {
        return this.settings;
    }

    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    public ApiKeyMode getApiKeyMode() {
        return this.apiKeyMode;
    }

    public String getBackground() {
        return this.background;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="owner")
    public void setPrimaryOwner(PrimaryOwnerEntity primaryOwner) {
        this.primaryOwner = primaryOwner;
    }

    @JsonProperty(value="settings")
    public void setSettings(ApplicationSettings settings) {
        this.settings = settings;
    }

    @JsonProperty(value="disable_membership_notifications")
    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    @JsonProperty(value="api_key_mode")
    public void setApiKeyMode(ApiKeyMode apiKeyMode) {
        this.apiKeyMode = apiKeyMode;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public String toString() {
        return "ApplicationEntity(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", domain=" + this.getDomain() + ", groups=" + this.getGroups() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", picture=" + this.getPicture() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", primaryOwner=" + this.getPrimaryOwner() + ", settings=" + this.getSettings() + ", disableMembershipNotifications=" + this.isDisableMembershipNotifications() + ", apiKeyMode=" + this.getApiKeyMode() + ", background=" + this.getBackground() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationEntity)) {
            return false;
        }
        ApplicationEntity other = (ApplicationEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApplicationEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

