/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.integration.controller.command.ingest;

import io.gravitee.apim.core.integration.use_case.IngestFederatedApisUseCase;
import io.gravitee.apim.infra.adapter.IntegrationAdapter;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.integration.api.command.IntegrationCommandType;
import io.gravitee.integration.api.command.ingest.IngestCommand;
import io.gravitee.integration.api.command.ingest.IngestReply;
import io.gravitee.integration.controller.command.IntegrationCommandContext;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IngestCommandHandler
implements CommandHandler<IngestCommand, IngestReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IngestCommandHandler.class);
    private final IngestFederatedApisUseCase ingestFederatedApisUseCase;
    private final IntegrationCommandContext integrationCommandContext;

    public String supportType() {
        return IntegrationCommandType.INGEST.name();
    }

    public Single<IngestReply> handle(IngestCommand command) {
        IngestCommand.Payload payload = (IngestCommand.Payload)command.getPayload();
        return this.ingestFederatedApisUseCase.execute(new IngestFederatedApisUseCase.Input(this.integrationCommandContext.getOrganizationId(), payload.ingestJobId(), payload.apis().stream().map(api -> IntegrationAdapter.INSTANCE.map(api, this.integrationCommandContext.getIntegrationId())).toList(), payload.done())).andThen((SingleSource)Single.just((Object)new IngestReply(command.getId()))).doOnError(throwable -> log.error("Unable to process ingest command payload for integration [{}]", (Object)this.integrationCommandContext.getIntegrationId(), throwable)).onErrorReturn(throwable -> new IngestReply(command.getId(), throwable.getMessage()));
    }

    @Generated
    public IngestCommandHandler(IngestFederatedApisUseCase ingestFederatedApisUseCase, IntegrationCommandContext integrationCommandContext) {
        this.ingestFederatedApisUseCase = ingestFederatedApisUseCase;
        this.integrationCommandContext = integrationCommandContext;
    }
}

