/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.integration.controller.websocket.auth;

import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.gravitee.apim.core.user.crud_service.UserCrudService;
import io.gravitee.exchange.controller.websocket.auth.WebSocketControllerAuthentication;
import io.gravitee.integration.controller.command.IntegrationCommandContext;
import io.gravitee.repository.management.model.Token;
import io.gravitee.rest.api.service.TokenService;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.rxjava3.core.MultiMap;
import io.vertx.rxjava3.core.http.HttpServerRequest;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="integrationWebsocketControllerAuthentication")
public class IntegrationWebsocketControllerAuthentication
implements WebSocketControllerAuthentication<IntegrationCommandContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrationWebsocketControllerAuthentication.class);
    static final String AUTHORIZATION_HEADER = HttpHeaderNames.AUTHORIZATION.toString();
    static final String ORGANIZATION_HEADER = "X-Gravitee-Organization-Id";
    static final String AUTHORIZATION_HEADER_BEARER = "bearer";
    private final TokenService tokenService;
    private final UserCrudService userCrudService;
    private final LicenseDomainService licenseDomainService;

    public IntegrationCommandContext authenticate(HttpServerRequest httpServerRequest) {
        MultiMap headers = httpServerRequest.headers();
        Optional<String> tokenValue = Optional.ofNullable(headers.get(AUTHORIZATION_HEADER)).map(authorizationHeader -> authorizationHeader.substring(AUTHORIZATION_HEADER_BEARER.length()).trim());
        if (tokenValue.isPresent()) {
            try {
                Token token = this.tokenService.findByToken(tokenValue.get());
                return this.userCrudService.findBaseUserById(token.getReferenceId()).map(user -> Map.entry(user.getOrganizationId(), user.getId())).filter(entry -> this.licenseDomainService.isFederationFeatureAllowed((String)entry.getKey())).map(entry -> new IntegrationCommandContext(true, (String)entry.getKey(), (String)entry.getValue())).orElse(new IntegrationCommandContext(false));
            }
            catch (Exception e) {
                log.warn("Unable to authenticate incoming websocket controller request");
            }
        }
        log.warn("No authentication authorizationHeader in the incoming websocket controller request");
        return new IntegrationCommandContext(false);
    }

    @Generated
    public IntegrationWebsocketControllerAuthentication(TokenService tokenService, UserCrudService userCrudService, LicenseDomainService licenseDomainService) {
        this.tokenService = tokenService;
        this.userCrudService = userCrudService;
        this.licenseDomainService = licenseDomainService;
    }
}

