/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.integration.controller.command.hello;

import io.gravitee.apim.core.integration.use_case.CheckIntegrationUseCase;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.exchange.api.command.hello.HelloReply;
import io.gravitee.exchange.api.command.hello.HelloReplyPayload;
import io.gravitee.integration.api.command.IntegrationCommandType;
import io.gravitee.integration.api.command.hello.HelloCommand;
import io.gravitee.integration.controller.command.IntegrationCommandContext;
import io.reactivex.rxjava3.core.Single;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelloCommandHandler
implements CommandHandler<HelloCommand, HelloReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HelloCommandHandler.class);
    private final CheckIntegrationUseCase checkIntegrationUseCase;
    private final IntegrationCommandContext integrationCommandContext;

    public String supportType() {
        return IntegrationCommandType.HELLO.name();
    }

    public Single<HelloReply> handle(HelloCommand command) {
        return Single.fromCallable(() -> {
            HelloCommand.Payload payload = (HelloCommand.Payload)command.getPayload();
            CheckIntegrationUseCase.Output result = this.checkIntegrationUseCase.execute(new CheckIntegrationUseCase.Input(this.integrationCommandContext.getOrganizationId(), payload.getTargetId(), payload.getProvider()));
            if (result.success()) {
                this.integrationCommandContext.setIntegrationId(payload.getTargetId());
                return new HelloReply(command.getId(), HelloReplyPayload.builder().targetId(payload.getTargetId()).build());
            }
            return new HelloReply(command.getId(), result.message());
        }).doOnError(throwable -> log.error("Unable to process hello command payload for target [{}]", (Object)((HelloCommand.Payload)command.getPayload()).getTargetId(), throwable)).onErrorReturn(throwable -> new HelloReply(command.getId(), throwable.getMessage()));
    }

    @Generated
    public HelloCommandHandler(CheckIntegrationUseCase checkIntegrationUseCase, IntegrationCommandContext integrationCommandContext) {
        this.checkIntegrationUseCase = checkIntegrationUseCase;
        this.integrationCommandContext = integrationCommandContext;
    }
}

