/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.entrypoint.internal;

import io.gravitee.plugin.core.api.AbstractSimplePluginHandler;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPlugin;
import io.gravitee.plugin.entrypoint.internal.DefaultEntrypointConnectorPlugin;
import io.gravitee.plugin.entrypoint.internal.EntrypointConnectorConfigurationClassFinder;
import io.gravitee.plugin.entrypoint.spring.EntrypointConnectorPluginConfiguration;
import java.io.IOException;
import java.net.URLClassLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Import;

@Import(value={EntrypointConnectorPluginConfiguration.class})
public class EntrypointConnectorPluginHandler
extends AbstractSimplePluginHandler<EntrypointConnectorPlugin<?, ?>> {
    @Autowired
    private ConfigurablePluginManager<EntrypointConnectorPlugin<?, ?>> entrypointPluginManager;

    public boolean canHandle(Plugin plugin) {
        return "entrypoint-connector".equalsIgnoreCase(plugin.type());
    }

    protected String type() {
        return "entrypoint-connector";
    }

    protected EntrypointConnectorPlugin<?, ?> create(Plugin plugin, Class<?> pluginClass) {
        Class configurationClass = new EntrypointConnectorConfigurationClassFinder().lookupFirst(pluginClass);
        return new DefaultEntrypointConnectorPlugin(plugin, pluginClass, configurationClass);
    }

    protected void register(EntrypointConnectorPlugin<?, ?> entrypointConnectorPlugin) {
        this.entrypointPluginManager.register(entrypointConnectorPlugin);
        ClassLoader policyClassLoader = entrypointConnectorPlugin.connectorFactory().getClassLoader();
        if (policyClassLoader instanceof URLClassLoader) {
            URLClassLoader classLoader = (URLClassLoader)policyClassLoader;
            try {
                classLoader.close();
            }
            catch (IOException e) {
                this.logger.error("Unexpected exception while trying to release the policy classloader");
            }
        }
    }

    protected ClassLoader getClassLoader(Plugin plugin) {
        return new URLClassLoader(plugin.dependencies(), ((Object)((Object)this)).getClass().getClassLoader());
    }
}

