/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.entrypoint.internal;

import io.gravitee.gateway.jupiter.api.connector.ConnectorHelper;
import io.gravitee.gateway.jupiter.api.connector.entrypoint.EntrypointConnectorFactory;
import io.gravitee.plugin.core.api.AbstractConfigurablePluginManager;
import io.gravitee.plugin.core.api.PluginClassLoader;
import io.gravitee.plugin.entrypoint.EntrypointConnectorClassLoaderFactory;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPlugin;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPluginManager;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEntrypointConnectorPluginManager
extends AbstractConfigurablePluginManager<EntrypointConnectorPlugin<?, ?>>
implements EntrypointConnectorPluginManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEntrypointConnectorPluginManager.class);
    private final EntrypointConnectorClassLoaderFactory classLoaderFactory;
    private final ConnectorHelper connectorHelper;
    private final Map<String, EntrypointConnectorFactory<?>> factories = new HashMap();

    public DefaultEntrypointConnectorPluginManager(EntrypointConnectorClassLoaderFactory classLoaderFactory, ConnectorHelper connectorHelper) {
        this.classLoaderFactory = classLoaderFactory;
        this.connectorHelper = connectorHelper;
    }

    public void register(EntrypointConnectorPlugin<?, ?> plugin) {
        super.register(plugin);
        PluginClassLoader pluginClassLoader = this.classLoaderFactory.getOrCreateClassLoader(plugin);
        try {
            Class connectorFactoryClass = pluginClassLoader.loadClass(plugin.clazz());
            EntrypointConnectorFactory<?> factory = this.createFactory(connectorFactoryClass);
            this.factories.put(plugin.id(), factory);
        }
        catch (Exception ex) {
            logger.error("Unexpected error while loading entrypoint plugin: {}", (Object)plugin.clazz(), (Object)ex);
        }
    }

    private EntrypointConnectorFactory<?> createFactory(Class<EntrypointConnectorFactory<?>> connectorFactoryClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        EntrypointConnectorFactory<?> factory;
        try {
            Constructor<EntrypointConnectorFactory<?>> constructorWithConfigurationHelper = connectorFactoryClass.getDeclaredConstructor(ConnectorHelper.class);
            factory = constructorWithConfigurationHelper.newInstance(this.connectorHelper);
        }
        catch (NoSuchMethodException e) {
            Constructor<EntrypointConnectorFactory<?>> emptyConstructor = connectorFactoryClass.getDeclaredConstructor(new Class[0]);
            factory = emptyConstructor.newInstance(new Object[0]);
        }
        return factory;
    }

    public EntrypointConnectorFactory<?> getFactoryById(String entrypointPluginId) {
        return this.factories.get(entrypointPluginId);
    }

    @Override
    public String getSubscriptionSchema(String pluginId) throws IOException {
        return this.getSchema(pluginId, "subscriptions");
    }
}

