/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.entrypoint.internal;

import io.gravitee.gateway.jupiter.api.connector.AbstractConnectorFactory;
import io.gravitee.gateway.jupiter.api.connector.entrypoint.EntrypointConnector;
import io.gravitee.plugin.core.api.AbstractConfigurablePluginManager;
import io.gravitee.plugin.core.api.PluginClassLoader;
import io.gravitee.plugin.entrypoint.EntrypointConnectorClassLoaderFactory;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPlugin;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPluginManager;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEntrypointConnectorPluginManager
extends AbstractConfigurablePluginManager<EntrypointConnectorPlugin<?>>
implements EntrypointConnectorPluginManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEntrypointConnectorPluginManager.class);
    private final EntrypointConnectorClassLoaderFactory classLoaderFactory;
    private final Map<String, AbstractConnectorFactory<? extends EntrypointConnector>> factories = new HashMap<String, AbstractConnectorFactory<? extends EntrypointConnector>>();

    public DefaultEntrypointConnectorPluginManager(EntrypointConnectorClassLoaderFactory classLoaderFactory) {
        this.classLoaderFactory = classLoaderFactory;
    }

    public void register(EntrypointConnectorPlugin<?> plugin) {
        super.register(plugin);
        PluginClassLoader pluginClassLoader = this.classLoaderFactory.getOrCreateClassLoader(plugin);
        try {
            Class connectorFactoryClass = pluginClassLoader.loadClass(plugin.clazz());
            AbstractConnectorFactory factory = (AbstractConnectorFactory)connectorFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.factories.put(plugin.id(), (AbstractConnectorFactory<? extends EntrypointConnector>)factory);
        }
        catch (Exception ex) {
            logger.error("Unexpected error while loading entrypoint plugin: {}", (Object)plugin.clazz(), (Object)ex);
        }
    }

    @Override
    public <T extends AbstractConnectorFactory<U>, U extends EntrypointConnector> T getFactoryById(String entrypointPluginId) {
        return (T)this.factories.get(entrypointPluginId);
    }
}

