/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.tcp.proxy;

import io.gravitee.common.service.AbstractService;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.reactive.api.ApiType;
import io.gravitee.gateway.reactive.api.ConnectorMode;
import io.gravitee.gateway.reactive.api.connector.Connector;
import io.gravitee.gateway.reactive.api.connector.endpoint.TcpEndpointConnector;
import io.gravitee.gateway.reactive.api.context.tcp.TcpExecutionContext;
import io.gravitee.gateway.reactive.tcp.VertxReadStreamUtil;
import io.gravitee.plugin.endpoint.tcp.proxy.client.TcpClientFactory;
import io.gravitee.plugin.endpoint.tcp.proxy.configuration.TcpProxyEndpointConnectorConfiguration;
import io.gravitee.plugin.endpoint.tcp.proxy.configuration.TcpProxyEndpointConnectorSharedConfiguration;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.vertx.rxjava3.core.streams.WriteStream;
import java.util.Set;

public class TcpProxyEndpointConnector
extends AbstractService<Connector>
implements TcpEndpointConnector {
    private static final String ENDPOINT_ID = "tcp-proxy";
    static final Set<ConnectorMode> SUPPORTED_MODES = Set.of(ConnectorMode.SOCKET);
    private final TcpProxyEndpointConnectorConfiguration configuration;
    private final TcpProxyEndpointConnectorSharedConfiguration sharedConfiguration;
    private final TcpClientFactory tcpClientFactory;

    TcpProxyEndpointConnector(TcpProxyEndpointConnectorConfiguration configuration, TcpProxyEndpointConnectorSharedConfiguration sharedConfiguration) {
        this.configuration = configuration;
        this.sharedConfiguration = sharedConfiguration;
        this.tcpClientFactory = new TcpClientFactory();
    }

    public String id() {
        return ENDPOINT_ID;
    }

    public ApiType supportedApi() {
        return ApiType.PROXY;
    }

    public Set<ConnectorMode> supportedModes() {
        return SUPPORTED_MODES;
    }

    public Completable connect(TcpExecutionContext ctx) {
        return this.tcpClientFactory.getOrBuildTcpClient(ctx, this.configuration, this.sharedConfiguration).rxConnect(this.configuration.getTcpTarget().getPort(), this.configuration.getTcpTarget().getHost()).doOnSuccess(backendSocket -> {
            backendSocket.pause();
            ctx.response().chunks(backendSocket.toFlowable().map(Buffer::buffer));
            ctx.request().pipeUpstream(VertxReadStreamUtil.toVertxRxReadStream((Flowable)ctx.request().chunks()).rxPipeTo((WriteStream)backendSocket));
        }).ignoreElement();
    }

    TcpProxyEndpointConnectorConfiguration getConfiguration() {
        return this.configuration;
    }

    TcpProxyEndpointConnectorSharedConfiguration getSharedConfiguration() {
        return this.sharedConfiguration;
    }
}

