/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.http.proxy;

import io.gravitee.common.http.MediaType;
import io.gravitee.gateway.reactive.api.ConnectorMode;
import io.gravitee.gateway.reactive.api.ExecutionFailure;
import io.gravitee.gateway.reactive.api.connector.endpoint.sync.EndpointSyncConnector;
import io.gravitee.gateway.reactive.api.context.ExecutionContext;
import io.gravitee.gateway.reactive.api.context.HttpExecutionContext;
import io.gravitee.gateway.reactive.api.context.HttpRequest;
import io.gravitee.gateway.reactive.api.context.Request;
import io.gravitee.gateway.reactive.core.context.interruption.InterruptionFailureException;
import io.gravitee.plugin.endpoint.http.proxy.client.GrpcHttpClientFactory;
import io.gravitee.plugin.endpoint.http.proxy.client.HttpClientFactory;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorConfiguration;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorSharedConfiguration;
import io.gravitee.plugin.endpoint.http.proxy.connector.GrpcConnector;
import io.gravitee.plugin.endpoint.http.proxy.connector.HttpConnector;
import io.gravitee.plugin.endpoint.http.proxy.connector.ProxyConnector;
import io.gravitee.plugin.endpoint.http.proxy.connector.WebSocketConnector;
import io.netty.channel.ConnectTimeoutException;
import io.netty.handler.timeout.ReadTimeoutException;
import io.reactivex.rxjava3.core.Completable;
import io.vertx.circuitbreaker.TimeoutException;
import io.vertx.core.impl.NoStackTraceTimeoutException;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyEndpointConnector
extends EndpointSyncConnector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpProxyEndpointConnector.class);
    private static final String ENDPOINT_ID = "http-proxy";
    private final Set<ConnectorMode> SUPPORTED_MODES = Set.of(ConnectorMode.REQUEST_RESPONSE);
    static final String GATEWAY_CLIENT_CONNECTION_ERROR = "GATEWAY_CLIENT_CONNECTION_ERROR";
    static final String REQUEST_TIMEOUT = "REQUEST_TIMEOUT";
    protected final HttpProxyEndpointConnectorConfiguration configuration;
    protected final HttpProxyEndpointConnectorSharedConfiguration sharedConfiguration;
    private final HttpClientFactory httpClientFactory;
    private final GrpcHttpClientFactory grpcHttpClientFactory;
    private final Map<String, ProxyConnector> connectors = new ConcurrentHashMap<String, ProxyConnector>(3);
    private final boolean targetStartWithGrpc;

    public HttpProxyEndpointConnector(HttpProxyEndpointConnectorConfiguration configuration, HttpProxyEndpointConnectorSharedConfiguration sharedConfiguration) {
        this.configuration = configuration;
        this.sharedConfiguration = sharedConfiguration;
        if (this.configuration.getTarget() == null || this.configuration.getTarget().isBlank()) {
            throw new IllegalArgumentException("target cannot be null or empty");
        }
        this.httpClientFactory = new HttpClientFactory();
        this.grpcHttpClientFactory = new GrpcHttpClientFactory();
        this.targetStartWithGrpc = configuration.getTarget().startsWith("grpc://");
    }

    public String id() {
        return ENDPOINT_ID;
    }

    public Set<ConnectorMode> supportedModes() {
        return this.SUPPORTED_MODES;
    }

    public Completable connect(ExecutionContext ctx) {
        return Completable.defer(() -> {
            Request request = ctx.request();
            return this.getConnector((HttpRequest)request).connect(ctx).onErrorResumeNext(throwable -> this.handleException((Throwable)throwable, (HttpExecutionContext)ctx));
        });
    }

    protected void doStop() {
        if (this.httpClientFactory != null) {
            this.httpClientFactory.close();
        }
        if (this.grpcHttpClientFactory != null) {
            this.grpcHttpClientFactory.close();
        }
    }

    private ProxyConnector getConnector(HttpRequest request) {
        if (request.isWebSocket()) {
            return this.connectors.computeIfAbsent("ws", type -> new WebSocketConnector(this.configuration, this.sharedConfiguration, this.httpClientFactory));
        }
        if (this.isGrpc(request)) {
            return this.connectors.computeIfAbsent("grpc", type -> new GrpcConnector(this.configuration, this.sharedConfiguration, this.grpcHttpClientFactory));
        }
        return this.connectors.computeIfAbsent("http", type -> new HttpConnector(this.configuration, this.sharedConfiguration, this.httpClientFactory));
    }

    private boolean isGrpc(HttpRequest httpRequest) {
        String contentType = httpRequest.headers().get((CharSequence)"Content-Type");
        if (contentType == null) {
            return this.targetStartWithGrpc;
        }
        MediaType mediaType = MediaType.parseMediaType((String)contentType);
        return MediaType.MEDIA_APPLICATION_GRPC.equals((Object)mediaType) || this.targetStartWithGrpc;
    }

    private Completable handleException(Throwable throwable, HttpExecutionContext ctx) {
        if (throwable instanceof InterruptionFailureException) {
            return Completable.error((Throwable)throwable);
        }
        if (throwable instanceof TimeoutException || throwable instanceof NoStackTraceTimeoutException || throwable instanceof ReadTimeoutException || throwable instanceof ConnectTimeoutException) {
            return ctx.interruptWith(new ExecutionFailure(504).key(REQUEST_TIMEOUT));
        }
        if (throwable instanceof IOException) {
            return ctx.interruptWith(new ExecutionFailure(502).key(GATEWAY_CLIENT_CONNECTION_ERROR));
        }
        return Completable.error((Throwable)throwable);
    }
}

