/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.http.proxy.connector;

import io.gravitee.common.http.HttpHeader;
import io.gravitee.common.util.MultiValueMap;
import io.gravitee.common.util.URIUtils;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.http.vertx.VertxHttpHeaders;
import io.gravitee.gateway.reactive.api.context.ExecutionContext;
import io.gravitee.gateway.reactive.api.context.Request;
import io.gravitee.gateway.reactive.api.context.Response;
import io.gravitee.gateway.reactive.http.vertx.VertxHttpServerResponse;
import io.gravitee.node.vertx.client.http.VertxHttpClientFactory;
import io.gravitee.plugin.endpoint.http.proxy.client.HttpClientFactory;
import io.gravitee.plugin.endpoint.http.proxy.client.UriHelper;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorConfiguration;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorSharedConfiguration;
import io.gravitee.plugin.endpoint.http.proxy.connector.ProxyConnector;
import io.netty.buffer.ByteBuf;
import io.reactivex.rxjava3.core.Completable;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.rxjava3.core.http.HttpClientRequest;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class HttpConnector
implements ProxyConnector {
    static final Set<CharSequence> HOP_HEADERS = Set.of("Connection", "Keep-Alive", "Proxy-Authorization", "Proxy-Authenticate", "Proxy-Connection", "TE", "Trailer", "Upgrade");
    private final String relativeTarget;
    private final String defaultHost;
    private final int defaultPort;
    private final boolean defaultSsl;
    private final MultiValueMap<String, String> targetParameters;
    protected final HttpProxyEndpointConnectorConfiguration configuration;
    protected final HttpProxyEndpointConnectorSharedConfiguration sharedConfiguration;
    protected final HttpClientFactory httpClientFactory;

    public HttpConnector(HttpProxyEndpointConnectorConfiguration configuration, HttpProxyEndpointConnectorSharedConfiguration sharedConfiguration, HttpClientFactory httpClientFactory) {
        this.configuration = configuration;
        this.sharedConfiguration = sharedConfiguration;
        this.httpClientFactory = httpClientFactory;
        URL targetUrl = VertxHttpClientFactory.buildUrl((String)configuration.getTarget());
        this.relativeTarget = targetUrl.getPath();
        this.defaultHost = targetUrl.getHost();
        this.defaultPort = targetUrl.getPort() != -1 ? targetUrl.getPort() : targetUrl.getDefaultPort();
        this.defaultSsl = VertxHttpClientFactory.isSecureProtocol((String)targetUrl.getProtocol());
        this.targetParameters = targetUrl.getQuery() == null ? null : URIUtils.parameters((String)(UriHelper.URI_QUERY_DELIMITER_CHAR_SEQUENCE + targetUrl.getQuery()));
    }

    @Override
    public Completable connect(ExecutionContext ctx) {
        try {
            Request request = ctx.request();
            Response response = ctx.response();
            RequestOptions options = this.buildRequestOptions(ctx);
            ctx.metrics().setEndpoint(VertxHttpClientFactory.toAbsoluteUri((RequestOptions)options, (String)this.defaultHost, (int)this.defaultPort));
            return this.httpClientFactory.getOrBuildHttpClient(ctx, this.configuration, this.sharedConfiguration).rxRequest(options).map(this::customizeHttpClientRequest).flatMap(httpClientRequest -> httpClientRequest.rxSend(request.chunks().map(buffer -> io.vertx.rxjava3.core.buffer.Buffer.buffer((ByteBuf)buffer.getNativeBuffer())))).doOnSuccess(endpointResponse -> {
                response.status(endpointResponse.statusCode());
                this.copyHeaders(endpointResponse.headers(), response.headers());
                if (endpointResponse.version() == HttpVersion.HTTP_2) {
                    endpointResponse.customFrameHandler(frame -> ((VertxHttpServerResponse)response).getNativeResponse().writeCustomFrame(frame));
                }
                response.chunks(endpointResponse.toFlowable().map(Buffer::buffer).doOnComplete(() -> this.copyHeaders(endpointResponse.trailers(), response.trailers())));
            }).ignoreElement();
        }
        catch (Exception e) {
            return Completable.error((Throwable)e);
        }
    }

    protected HttpClientRequest customizeHttpClientRequest(HttpClientRequest httpClientRequest) {
        return httpClientRequest;
    }

    protected void copyHeaders(io.vertx.rxjava3.core.MultiMap sourceHeaders, io.gravitee.gateway.api.http.HttpHeaders targetHeaders) {
        if (sourceHeaders != null && !sourceHeaders.isEmpty()) {
            if (targetHeaders instanceof VertxHttpHeaders) {
                ((VertxHttpHeaders)targetHeaders).getDelegate().addAll(sourceHeaders.getDelegate());
            } else {
                sourceHeaders.forEach(entry -> targetHeaders.add((CharSequence)entry.getKey(), (CharSequence)entry.getValue()));
            }
        }
    }

    protected RequestOptions buildRequestOptions(ExecutionContext ctx) {
        RequestOptions requestOptions = new RequestOptions();
        Request request = ctx.request();
        io.gravitee.gateway.api.http.HttpHeaders requestHeaders = request.headers();
        String originalHost = request.originalHost();
        String currentRequestHost = request.host();
        for (CharSequence header2 : this.hopHeaders()) {
            requestHeaders.remove((CharSequence)header2.toString());
        }
        if (currentRequestHost != null && !Objects.equals(originalHost, currentRequestHost)) {
            requestHeaders.set((CharSequence)"Host", (CharSequence)currentRequestHost);
        } else {
            requestHeaders.remove((CharSequence)"Host");
        }
        if (!this.sharedConfiguration.getHttpOptions().isPropagateClientAcceptEncoding()) {
            requestHeaders.remove(HttpHeaders.ACCEPT_ENCODING);
        }
        this.prepareUriAndQueryParameters(ctx, requestOptions);
        List<HttpHeader> configHeaders = this.sharedConfiguration.getHeaders();
        if (configHeaders != null && !configHeaders.isEmpty()) {
            configHeaders.forEach(header -> requestHeaders.set((CharSequence)header.getName(), (CharSequence)header.getValue()));
        }
        if (requestHeaders instanceof VertxHttpHeaders) {
            requestOptions.setHeaders(((VertxHttpHeaders)requestHeaders).getDelegate());
        } else {
            HeadersMultiMap headers = new HeadersMultiMap();
            requestHeaders.names().forEach(arg_0 -> HttpConnector.lambda$buildRequestOptions$7((MultiMap)headers, requestHeaders, arg_0));
            requestOptions.setHeaders((MultiMap)headers);
        }
        return requestOptions.setMethod(HttpMethod.valueOf((String)request.method().name())).setTimeout(this.sharedConfiguration.getHttpOptions().getReadTimeout()).setFollowRedirects(Boolean.valueOf(this.sharedConfiguration.getHttpOptions().isFollowRedirects()));
    }

    protected Set<CharSequence> hopHeaders() {
        return HOP_HEADERS;
    }

    private void prepareUriAndQueryParameters(ExecutionContext ctx, RequestOptions requestOptions) {
        Request request = ctx.request();
        MultiValueMap requestParameters = request.parameters();
        this.addParameters((MultiValueMap<String, String>)requestParameters, this.targetParameters);
        String customEndpointTarget = (String)ctx.getAttribute("gravitee.attribute.request.endpoint");
        Object uri = this.relativeTarget;
        boolean isRelative = true;
        if (customEndpointTarget != null) {
            boolean endpointOverride = Boolean.TRUE.equals(ctx.getAttribute("gravitee.attribute.request.endpoint.override"));
            MultiValueMap customEndpointParameters = URIUtils.parameters((String)customEndpointTarget);
            if (!customEndpointParameters.isEmpty()) {
                customEndpointTarget = customEndpointTarget.substring(0, customEndpointTarget.indexOf(63));
                this.addParameters((MultiValueMap<String, String>)requestParameters, (MultiValueMap<String, String>)customEndpointParameters);
            }
            if (URIUtils.isAbsolute((String)customEndpointTarget)) {
                uri = customEndpointTarget;
                isRelative = false;
            } else {
                uri = endpointOverride ? customEndpointTarget : this.relativeTarget + customEndpointTarget;
            }
        } else {
            uri = (String)uri + request.pathInfo();
        }
        if (isRelative) {
            UriHelper.configureRelativeUri(requestOptions, (String)uri, (MultiValueMap<String, String>)requestParameters);
            requestOptions.setSsl(Boolean.valueOf(this.defaultSsl));
        } else {
            UriHelper.configureAbsoluteUri(requestOptions, (String)uri, (MultiValueMap<String, String>)requestParameters);
        }
    }

    private void addParameters(MultiValueMap<String, String> parameters, MultiValueMap<String, String> parametersToAdd) {
        if (parametersToAdd != null && !parametersToAdd.isEmpty()) {
            parametersToAdd.forEach((key, values) -> ((List)parameters.computeIfAbsent(key, k -> new ArrayList())).addAll(values));
        }
    }

    private static /* synthetic */ void lambda$buildRequestOptions$7(MultiMap headers, io.gravitee.gateway.api.http.HttpHeaders requestHeaders, String name) {
        headers.add(name, (Iterable)requestHeaders.getAll((CharSequence)name));
    }
}

