/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.http.proxy.client;

import io.gravitee.common.util.MultiValueMap;
import io.gravitee.node.vertx.client.http.VertxHttpClientFactory;
import io.vertx.core.http.RequestOptions;
import java.net.URL;
import java.util.StringJoiner;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UriHelper.class);
    public static final String URI_PARAM_SEPARATOR = "&";
    public static final char URI_PARAM_SEPARATOR_CHAR = '&';
    public static final char URI_PARAM_VALUE_SEPARATOR_CHAR = '=';
    public static final char URI_QUERY_DELIMITER_CHAR = '?';
    public static final CharSequence URI_QUERY_DELIMITER_CHAR_SEQUENCE = "?";

    public static RequestOptions configureAbsoluteUri(RequestOptions requestOptions, String uri, MultiValueMap<String, String> parameters) {
        URL target = VertxHttpClientFactory.buildUrl((String)UriHelper.buildFinalUri(uri, parameters));
        boolean secureProtocol = VertxHttpClientFactory.isSecureProtocol((String)target.getProtocol());
        return requestOptions.setURI((String)(target.getQuery() == null ? target.getPath() : target.getPath() + "?" + target.getQuery())).setPort(Integer.valueOf(VertxHttpClientFactory.getPort((URL)target, (boolean)secureProtocol))).setSsl(Boolean.valueOf(secureProtocol)).setHost(target.getHost());
    }

    public static RequestOptions configureRelativeUri(RequestOptions requestOptions, String uri, MultiValueMap<String, String> parameters) {
        return requestOptions.setURI(UriHelper.buildFinalUri(uri, parameters));
    }

    private static String buildFinalUri(String targetUri, MultiValueMap<String, String> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            StringJoiner parametersAsString = new StringJoiner(URI_PARAM_SEPARATOR);
            parameters.forEach((paramName, paramValues) -> {
                if (paramValues != null) {
                    for (String paramValue : paramValues) {
                        if (paramValue == null) {
                            parametersAsString.add((CharSequence)paramName);
                            continue;
                        }
                        parametersAsString.add(paramName + "=" + paramValue);
                    }
                }
            });
            if (targetUri.contains(URI_QUERY_DELIMITER_CHAR_SEQUENCE)) {
                return targetUri + URI_PARAM_SEPARATOR + String.valueOf(parametersAsString);
            }
            return targetUri + "?" + String.valueOf(parametersAsString);
        }
        return targetUri;
    }

    @Generated
    private UriHelper() {
    }
}

