/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.internal;

import io.gravitee.gateway.jupiter.api.connector.ConnectorHelper;
import io.gravitee.gateway.jupiter.api.connector.endpoint.EndpointConnectorFactory;
import io.gravitee.plugin.core.api.AbstractConfigurablePluginManager;
import io.gravitee.plugin.core.api.PluginClassLoader;
import io.gravitee.plugin.endpoint.EndpointConnectorClassLoaderFactory;
import io.gravitee.plugin.endpoint.EndpointConnectorPlugin;
import io.gravitee.plugin.endpoint.EndpointConnectorPluginManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEndpointConnectorPluginManager
extends AbstractConfigurablePluginManager<EndpointConnectorPlugin<?, ?>>
implements EndpointConnectorPluginManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEndpointConnectorPluginManager.class);
    private final EndpointConnectorClassLoaderFactory classLoaderFactory;
    private final Map<String, EndpointConnectorFactory<?>> factories = new HashMap();
    private final ConnectorHelper connectorHelper;

    public DefaultEndpointConnectorPluginManager(EndpointConnectorClassLoaderFactory classLoaderFactory, ConnectorHelper connectorHelper) {
        this.classLoaderFactory = classLoaderFactory;
        this.connectorHelper = connectorHelper;
    }

    public void register(EndpointConnectorPlugin<?, ?> plugin) {
        super.register(plugin);
        PluginClassLoader pluginClassLoader = this.classLoaderFactory.getOrCreateClassLoader(plugin);
        try {
            Class connectorFactoryClass = pluginClassLoader.loadClass(plugin.clazz());
            EndpointConnectorFactory<?> factory = this.createFactory(connectorFactoryClass);
            this.factories.put(plugin.id(), factory);
        }
        catch (Exception ex) {
            logger.error("Unexpected error while loading endpoint plugin: {}", (Object)plugin.clazz(), (Object)ex);
        }
    }

    private EndpointConnectorFactory<?> createFactory(Class<EndpointConnectorFactory<?>> connectorFactoryClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        EndpointConnectorFactory<?> factory;
        try {
            Constructor<EndpointConnectorFactory<?>> constructorWithConfigurationHelper = connectorFactoryClass.getDeclaredConstructor(ConnectorHelper.class);
            factory = constructorWithConfigurationHelper.newInstance(this.connectorHelper);
        }
        catch (NoSuchMethodException e) {
            Constructor<EndpointConnectorFactory<?>> emptyConstructor = connectorFactoryClass.getDeclaredConstructor(new Class[0]);
            factory = emptyConstructor.newInstance(new Object[0]);
        }
        return factory;
    }

    public EndpointConnectorFactory<?> getFactoryById(String endpointPluginId) {
        return this.factories.get(endpointPluginId);
    }
}

