/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.apiservice.internal;

import io.gravitee.gateway.reactive.api.apiservice.ApiServiceFactory;
import io.gravitee.gateway.reactive.api.helper.PluginConfigurationHelper;
import io.gravitee.plugin.apiservice.ApiServiceClassLoaderFactory;
import io.gravitee.plugin.apiservice.ApiServicePlugin;
import io.gravitee.plugin.apiservice.ApiServicePluginManager;
import io.gravitee.plugin.core.api.AbstractConfigurablePluginManager;
import io.gravitee.plugin.core.api.PluginClassLoader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApiServicePluginManager
extends AbstractConfigurablePluginManager<ApiServicePlugin<?, ?>>
implements ApiServicePluginManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultApiServicePluginManager.class);
    private final ApiServiceClassLoaderFactory classLoaderFactory;
    private final Map<String, ApiServiceFactory<?>> factories = new HashMap();
    private final Map<String, ApiServiceFactory<?>> notDeployedPluginFactories = new HashMap();
    private final PluginConfigurationHelper pluginConfigurationHelper;

    public DefaultApiServicePluginManager(ApiServiceClassLoaderFactory classLoaderFactory, PluginConfigurationHelper pluginConfigurationHelper) {
        this.classLoaderFactory = classLoaderFactory;
        this.pluginConfigurationHelper = pluginConfigurationHelper;
    }

    public void register(ApiServicePlugin<?, ?> plugin) {
        super.register(plugin);
        PluginClassLoader pluginClassLoader = this.classLoaderFactory.getOrCreateClassLoader(plugin);
        try {
            Class connectorFactoryClass = pluginClassLoader.loadClass(plugin.clazz());
            ApiServiceFactory<?> factory = this.createFactory(connectorFactoryClass);
            if (plugin.deployed()) {
                this.factories.put(plugin.id(), factory);
            } else {
                this.notDeployedPluginFactories.put(plugin.id(), factory);
            }
        }
        catch (Exception ex) {
            log.error("Unexpected error while loading api service plugin: {}", (Object)plugin.clazz(), (Object)ex);
        }
    }

    private ApiServiceFactory<?> createFactory(Class<ApiServiceFactory<?>> connectorFactoryClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ApiServiceFactory<?> factory;
        try {
            Constructor<ApiServiceFactory<?>> constructorWithFactoryHelper = connectorFactoryClass.getDeclaredConstructor(PluginConfigurationHelper.class);
            factory = constructorWithFactoryHelper.newInstance(this.pluginConfigurationHelper);
        }
        catch (NoSuchMethodException e) {
            Constructor<ApiServiceFactory<?>> constructorWithFactoryHelper = connectorFactoryClass.getDeclaredConstructor(new Class[0]);
            factory = constructorWithFactoryHelper.newInstance(new Object[0]);
        }
        return factory;
    }

    public ApiServiceFactory<?> getFactoryById(String apiServicePluginId) {
        return this.getFactoryById(apiServicePluginId, false);
    }

    public ApiServiceFactory<?> getFactoryById(String apiServicePluginId, boolean includeNotDeployed) {
        ApiServiceFactory<?> factory = this.factories.get(apiServicePluginId);
        if (factory == null && includeNotDeployed) {
            return this.notDeployedPluginFactories.get(apiServicePluginId);
        }
        return factory;
    }

    public List<?> getAllFactories() {
        return this.getAllFactories(false);
    }

    public List<?> getAllFactories(boolean includeNotDeployed) {
        ArrayList allFactories = new ArrayList(this.factories.values());
        if (includeNotDeployed) {
            allFactories.addAll(this.notDeployedPluginFactories.values());
        }
        return allFactories;
    }
}

