/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.plugin.apiservice.dynamicproperties.http.http;

import io.gravitee.apim.plugin.apiservice.dynamicproperties.http.HttpDynamicPropertiesServiceConfiguration;
import io.gravitee.apim.rest.api.common.apiservices.ManagementDeploymentContext;
import io.gravitee.node.api.configuration.Configuration;
import io.gravitee.node.vertx.client.http.VertxHttpClientFactory;
import io.gravitee.node.vertx.client.http.VertxHttpClientOptions;
import io.vertx.rxjava3.core.Vertx;
import io.vertx.rxjava3.core.http.HttpClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import lombok.Generated;

public class HttpClientFactory {
    public static final URLStreamHandler URL_HANDLER = new URLStreamHandler(){

        @Override
        protected URLConnection openConnection(URL u) {
            return null;
        }
    };
    private static final String HTTPS_SCHEME = "https";
    public static final int UNSECURE_PORT = 80;
    public static final int SECURE_PORT = 443;

    public static HttpClient createClient(ManagementDeploymentContext deploymentContext, HttpDynamicPropertiesServiceConfiguration configuration) {
        return VertxHttpClientFactory.builder().vertx((Vertx)deploymentContext.getComponent(Vertx.class)).nodeConfiguration((Configuration)deploymentContext.getComponent(Configuration.class)).defaultTarget(configuration.getUrl()).httpOptions(VertxHttpClientOptions.builder().maxConcurrentConnections(1).build()).build().createHttpClient();
    }

    public static URL buildUrl(String uri) {
        try {
            return new URL(null, uri, URL_HANDLER);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Target [" + uri + "] is not valid");
        }
    }

    public static boolean isSecureProtocol(String protocol) {
        return HTTPS_SCHEME.equalsIgnoreCase(protocol);
    }

    public static int getPort(URL target, boolean isSecured) {
        int defaultPort = isSecured ? 443 : 80;
        return target.getPort() != -1 ? target.getPort() : defaultPort;
    }

    @Generated
    private HttpClientFactory() {
    }
}

