/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.debug.reactor.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.HttpResponse;
import io.gravitee.definition.model.PolicyScope;
import io.gravitee.definition.model.debug.DebugApiProxy;
import io.gravitee.definition.model.debug.DebugApiV2;
import io.gravitee.definition.model.debug.DebugApiV4;
import io.gravitee.definition.model.debug.DebugMetrics;
import io.gravitee.definition.model.debug.DebugStep;
import io.gravitee.definition.model.debug.PreprocessorStep;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.debug.definition.ReactableDebugApi;
import io.gravitee.gateway.reactive.api.ExecutionPhase;
import io.gravitee.gateway.reactive.core.context.HttpExecutionContextInternal;
import io.gravitee.gateway.reactive.core.processor.Processor;
import io.gravitee.gateway.reactive.debug.policy.steps.PolicyStep;
import io.gravitee.gateway.reactive.debug.reactor.context.DebugExecutionContext;
import io.gravitee.reporter.api.v4.metric.Metrics;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.model.ApiDebugStatus;
import io.gravitee.repository.management.model.Event;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class DebugCompletionProcessor
implements Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugCompletionProcessor.class);
    private final EventRepository eventRepository;
    private final ObjectMapper objectMapper;

    public DebugCompletionProcessor(EventRepository eventRepository, ObjectMapper objectMapper) {
        this.eventRepository = eventRepository;
        this.objectMapper = objectMapper;
    }

    public String getId() {
        return "processor-debug-completion";
    }

    public Completable execute(HttpExecutionContextInternal ctx) {
        return Completable.defer(() -> {
            DebugExecutionContext debugContext = (DebugExecutionContext)ctx;
            ReactableDebugApi<?> debugApi = this.getDebugApi((HttpExecutionContextInternal)debugContext);
            return Maybe.fromCallable(() -> this.eventRepository.findById((Object)debugApi.getEventId())).flatMapCompletable(eventOptional -> {
                if (eventOptional.isPresent()) {
                    Event event = (Event)eventOptional.get();
                    return this.computeDebugApiEventPayload(debugContext, debugApi).doOnSuccess(definitionDebugApi -> {
                        event.setPayload(this.objectMapper.writeValueAsString(definitionDebugApi));
                        this.updateEvent(event, ApiDebugStatus.SUCCESS);
                    }).ignoreElement().onErrorResumeNext(throwable -> {
                        LOGGER.error("Error occurs while saving debug event", throwable);
                        this.failEvent(event);
                        return Completable.complete();
                    });
                }
                return Completable.complete();
            });
        }).subscribeOn(Schedulers.io());
    }

    private Single<DebugApiProxy> computeDebugApiEventPayload(DebugExecutionContext debugContext, ReactableDebugApi<?> debugApi) {
        return Single.defer(() -> {
            DebugApiProxy definitionDebugApi = this.convert(debugApi);
            PreprocessorStep preprocessorStep = this.createPreprocessorStep(debugContext);
            definitionDebugApi.setPreprocessorStep(preprocessorStep);
            definitionDebugApi.setDebugSteps(this.convert(debugContext.getDebugSteps()));
            HttpResponse invokerResponse = this.createResponse(debugContext.getInvokerResponse().getHeaders(), debugContext.getInvokerResponse().getStatus(), debugContext.getInvokerResponse().getBuffer());
            definitionDebugApi.setBackendResponse(invokerResponse);
            definitionDebugApi.setMetrics(this.createMetrics(debugContext.metrics()));
            return debugContext.response().bodyOrEmpty().map(buffer -> {
                HttpResponse response = this.createResponse(debugContext.response().headers(), debugContext.response().status(), (Buffer)buffer);
                definitionDebugApi.setResponse(response);
                return definitionDebugApi;
            });
        });
    }

    private ReactableDebugApi<?> getDebugApi(HttpExecutionContextInternal ctx) {
        ReactableDebugApi debugApi;
        try {
            debugApi = (ReactableDebugApi)ctx.getComponent(io.gravitee.gateway.handlers.api.definition.Api.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            debugApi = (ReactableDebugApi)ctx.getComponent(io.gravitee.gateway.reactive.handlers.api.v4.Api.class);
        }
        return debugApi;
    }

    private DebugMetrics createMetrics(Metrics metrics) {
        DebugMetrics debugMetrics = new DebugMetrics();
        if (metrics != null) {
            debugMetrics.setApiResponseTimeMs(metrics.getEndpointResponseTimeMs());
            debugMetrics.setProxyLatencyMs(metrics.getGatewayLatencyMs());
            debugMetrics.setProxyResponseTimeMs(metrics.getGatewayResponseTimeMs());
        }
        return debugMetrics;
    }

    private PreprocessorStep createPreprocessorStep(DebugExecutionContext debugContext) {
        PreprocessorStep preprocessorStep = new PreprocessorStep();
        preprocessorStep.setAttributes(debugContext.getInitialAttributes());
        preprocessorStep.setHeaders(debugContext.getInitialHeaders().toListValuesMap());
        return preprocessorStep;
    }

    private HttpResponse createResponse(HttpHeaders httpHeaders, int statusCode, Buffer bodyBuffer) {
        HttpResponse response = new HttpResponse();
        if (httpHeaders != null) {
            response.setHeaders(httpHeaders.toListValuesMap());
        }
        response.statusCode(statusCode);
        if (bodyBuffer != null) {
            response.setBody(bodyBuffer.toString());
        }
        return response;
    }

    private void failEvent(@NonNull Event debugEvent) {
        try {
            this.updateEvent(debugEvent, ApiDebugStatus.ERROR);
        }
        catch (TechnicalException e) {
            LOGGER.error("Error when updating event {} with ERROR status", (Object)debugEvent.getId());
        }
    }

    private void updateEvent(@NonNull Event debugEvent, ApiDebugStatus apiDebugStatus) throws TechnicalException {
        debugEvent.getProperties().put(Event.EventProperties.API_DEBUG_STATUS.getValue(), apiDebugStatus.name());
        this.eventRepository.update((Object)debugEvent);
    }

    private DebugApiProxy convert(ReactableDebugApi<?> content) {
        if (content instanceof io.gravitee.gateway.debug.definition.DebugApiV2) {
            io.gravitee.gateway.debug.definition.DebugApiV2 debugApiV2 = (io.gravitee.gateway.debug.definition.DebugApiV2)content;
            DebugApiV2 debugAPI = new DebugApiV2();
            debugAPI.setName(debugApiV2.getName());
            debugAPI.setId(debugApiV2.getId());
            debugAPI.setDefinitionVersion(debugApiV2.getDefinitionVersion());
            debugAPI.setResponse(debugApiV2.getResponse());
            debugAPI.setRequest(debugApiV2.getRequest());
            debugAPI.setFlowMode(((io.gravitee.definition.model.Api)debugApiV2.getDefinition()).getFlowMode());
            debugAPI.setFlows(((io.gravitee.definition.model.Api)debugApiV2.getDefinition()).getFlows());
            debugAPI.setPathMappings(((io.gravitee.definition.model.Api)debugApiV2.getDefinition()).getPathMappings());
            debugAPI.setPlans(((io.gravitee.definition.model.Api)debugApiV2.getDefinition()).getPlans());
            debugAPI.setPaths(((io.gravitee.definition.model.Api)debugApiV2.getDefinition()).getPaths());
            debugAPI.setServices(((io.gravitee.definition.model.Api)debugApiV2.getDefinition()).getServices());
            debugAPI.setProxy(((io.gravitee.definition.model.Api)debugApiV2.getDefinition()).getProxy());
            debugAPI.setProperties(((io.gravitee.definition.model.Api)debugApiV2.getDefinition()).getProperties());
            debugAPI.setResources(((io.gravitee.definition.model.Api)debugApiV2.getDefinition()).getResources());
            debugAPI.setServices(((io.gravitee.definition.model.Api)debugApiV2.getDefinition()).getServices());
            debugAPI.setResponseTemplates(((io.gravitee.definition.model.Api)debugApiV2.getDefinition()).getResponseTemplates());
            debugAPI.setExecutionMode(((io.gravitee.definition.model.Api)debugApiV2.getDefinition()).getExecutionMode());
            return debugAPI;
        }
        if (content instanceof io.gravitee.gateway.debug.definition.DebugApiV4) {
            io.gravitee.gateway.debug.definition.DebugApiV4 debugApiV4 = (io.gravitee.gateway.debug.definition.DebugApiV4)content;
            return new DebugApiV4((Api)debugApiV4.getDefinition(), debugApiV4.getRequest(), debugApiV4.getResponse());
        }
        throw new IllegalArgumentException("Unsupported debug API: " + content.getClass().getSimpleName());
    }

    private List<DebugStep> convert(List<PolicyStep<?>> policySteps) {
        return policySteps.stream().map(this::convert).collect(Collectors.toList());
    }

    private DebugStep convert(PolicyStep<?> ds) {
        DebugStep debugStep = new DebugStep();
        debugStep.setPolicyInstanceId(ds.getId());
        debugStep.setPolicyId(ds.getPolicyId());
        debugStep.setDuration(Long.valueOf(ds.elapsedTime().toNanos()));
        debugStep.setStatus(ds.getStatus());
        debugStep.setCondition(ds.getCondition());
        debugStep.setError(ds.getError());
        debugStep.setStage(ds.getFlowPhase());
        if (ds.getExecutionPhase() == ExecutionPhase.REQUEST) {
            debugStep.setScope(PolicyScope.ON_REQUEST);
        } else if (ds.getExecutionPhase() == ExecutionPhase.RESPONSE) {
            debugStep.setScope(PolicyScope.ON_RESPONSE);
        }
        HashMap result = new HashMap();
        ds.getDiff().forEach((key, value) -> {
            if ("headers".equals(key)) {
                result.put("headers", ((HttpHeaders)value).toListValuesMap());
            } else if ("bodyBuffer".equals(key)) {
                result.put("body", value.toString());
            } else {
                result.put(key, value);
            }
        });
        debugStep.setResult(result);
        return debugStep;
    }
}

