/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.core.invoker;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.api.proxy.ProxyConnection;
import io.gravitee.gateway.api.proxy.ProxyResponse;
import io.gravitee.gateway.api.stream.ReadStream;
import io.gravitee.gateway.api.stream.WriteStream;
import io.gravitee.gateway.debug.reactor.handler.context.DebugExecutionContext;

public class DebugProxyConnection
implements ProxyConnection {
    private final ProxyConnection proxyConnection;
    private final DebugExecutionContext context;

    public DebugProxyConnection(ProxyConnection proxyConnection, ExecutionContext context) {
        this.proxyConnection = proxyConnection;
        this.context = (DebugExecutionContext)context;
    }

    public ProxyConnection cancel() {
        return this.proxyConnection.cancel();
    }

    public ProxyConnection exceptionHandler(Handler<Throwable> timeoutHandler) {
        return this.proxyConnection.exceptionHandler(timeoutHandler);
    }

    public ProxyConnection responseHandler(Handler<ProxyResponse> responseHandler) {
        return this.responseHandler(this.proxyConnection, responseHandler, this.context);
    }

    public void end() {
        this.proxyConnection.end();
    }

    public WriteStream<Buffer> write(Buffer chunk) {
        this.proxyConnection.write((Object)chunk);
        return this;
    }

    protected ProxyConnection responseHandler(ProxyConnection proxyConnection, Handler<ProxyResponse> responseHandler, DebugExecutionContext context) {
        return proxyConnection.responseHandler((Handler)new DebugProxyResponseHandler(responseHandler, context));
    }

    static class DebugProxyResponseHandler
    implements Handler<ProxyResponse> {
        private final Handler<ProxyResponse> responseHandler;
        protected final DebugExecutionContext context;

        DebugProxyResponseHandler(Handler<ProxyResponse> responseHandler, DebugExecutionContext context) {
            this.responseHandler = responseHandler;
            this.context = context;
        }

        public void handle(ProxyResponse proxyResponse) {
            this.handle(this.responseHandler, proxyResponse);
        }

        protected void handle(Handler<ProxyResponse> responseHandler, ProxyResponse proxyResponse) {
            this.context.getInvokerResponse().setHeaders(proxyResponse.headers());
            this.context.getInvokerResponse().setStatus(proxyResponse.status());
            responseHandler.handle((Object)new DebugProxyResponse(proxyResponse, this.context));
        }
    }

    static class DebugProxyResponse
    implements ProxyResponse {
        private final ProxyResponse proxyResponse;
        private final DebugExecutionContext context;

        DebugProxyResponse(ProxyResponse proxyResponse, DebugExecutionContext context) {
            this.proxyResponse = proxyResponse;
            this.context = context;
        }

        public ReadStream<Buffer> bodyHandler(Handler<Buffer> bodyHandler) {
            this.proxyResponse.bodyHandler(chunk -> {
                this.context.getInvokerResponse().getBuffer().appendBuffer(chunk);
                bodyHandler.handle(chunk);
            });
            return this;
        }

        public ReadStream<Buffer> endHandler(Handler<Void> endHandler) {
            this.proxyResponse.endHandler(arg_0 -> endHandler.handle(arg_0));
            return this;
        }

        public ReadStream<Buffer> pause() {
            return this.proxyResponse.pause();
        }

        public ReadStream<Buffer> resume() {
            return this.proxyResponse.resume();
        }

        public HttpHeaders headers() {
            return this.proxyResponse.headers();
        }

        public int status() {
            return this.proxyResponse.status();
        }

        public boolean connected() {
            return this.proxyResponse.connected();
        }
    }
}

