/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.security.oauth2.policy;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.service.Subscription;
import io.gravitee.gateway.api.service.SubscriptionService;
import io.gravitee.gateway.policy.Policy;
import io.gravitee.gateway.policy.PolicyException;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.PolicyResult;
import io.gravitee.reporter.api.http.SecurityType;
import java.util.Optional;

public class CheckSubscriptionPolicy
implements Policy {
    static final String CONTEXT_ATTRIBUTE_PLAN_SELECTION_RULE_BASED = "gravitee.attribute.gravitee.attribute.plan.selection.rule.based";
    static final String CONTEXT_ATTRIBUTE_CLIENT_ID = "oauth.client_id";
    static final String BEARER_AUTHORIZATION_TYPE = "Bearer";
    static final String GATEWAY_OAUTH2_ACCESS_DENIED_KEY = "GATEWAY_OAUTH2_ACCESS_DENIED";
    static final String GATEWAY_OAUTH2_INVALID_CLIENT_KEY = "GATEWAY_OAUTH2_INVALID_CLIENT";
    static final String OAUTH2_UNAUTHORIZED_MESSAGE = "Unauthorized";

    public void execute(PolicyChain policyChain, ExecutionContext executionContext) throws PolicyException {
        boolean selectionRuleBasedPlan;
        Subscription subscription;
        SubscriptionService subscriptionService = (SubscriptionService)executionContext.getComponent(SubscriptionService.class);
        String api = (String)executionContext.getAttribute("gravitee.attribute.api");
        String clientId = (String)executionContext.getAttribute(CONTEXT_ATTRIBUTE_CLIENT_ID);
        String plan = (String)executionContext.getAttribute("gravitee.attribute.plan");
        if (clientId == null || clientId.trim().isEmpty()) {
            this.sendError(GATEWAY_OAUTH2_INVALID_CLIENT_KEY, executionContext.response(), policyChain);
            return;
        }
        executionContext.request().metrics().setSecurityType(SecurityType.OAUTH2);
        executionContext.request().metrics().setSecurityToken(clientId);
        Object validateSubscription = executionContext.getAttribute("api.validateSubscription");
        if (validateSubscription != null && !((Boolean)validateSubscription).booleanValue()) {
            policyChain.doNext(executionContext.request(), executionContext.response());
            return;
        }
        Optional optionalSubscription = subscriptionService.getByApiAndClientIdAndPlan(api, clientId, plan);
        if (optionalSubscription.isPresent() && (subscription = (Subscription)optionalSubscription.filter(arg_0 -> CheckSubscriptionPolicy.lambda$execute$0(selectionRuleBasedPlan = Boolean.TRUE.equals(executionContext.getAttribute(CONTEXT_ATTRIBUTE_PLAN_SELECTION_RULE_BASED)), plan, arg_0)).orElse(null)) != null && subscription.isTimeValid(executionContext.request().timestamp())) {
            executionContext.setAttribute("gravitee.attribute.application", (Object)subscription.getApplication());
            executionContext.setAttribute("gravitee.attribute.user-id", (Object)subscription.getId());
            executionContext.setAttribute("gravitee.attribute.plan", (Object)subscription.getPlan());
            policyChain.doNext(executionContext.request(), executionContext.response());
            return;
        }
        policyChain.failWith(PolicyResult.failure((String)GATEWAY_OAUTH2_ACCESS_DENIED_KEY, (int)401, (String)OAUTH2_UNAUTHORIZED_MESSAGE));
    }

    private void sendError(String key, Response response, PolicyChain policyChain) {
        String headerValue = "Bearer realm=\"gravitee.io\"";
        response.headers().add((CharSequence)"WWW-Authenticate", (CharSequence)headerValue);
        policyChain.failWith(PolicyResult.failure((String)key, (int)401, (String)OAUTH2_UNAUTHORIZED_MESSAGE));
    }

    public String id() {
        return "check-subscription";
    }

    private static /* synthetic */ boolean lambda$execute$0(boolean selectionRuleBasedPlan, String plan, Subscription sub) {
        return !selectionRuleBasedPlan || sub.getPlan().equals(plan);
    }
}

