/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.security.oauth2;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import java.util.Map;

public class LazyJwtToken {
    private final String token;
    private Map<String, Object> headers;
    private Map<String, Object> claims;
    private boolean parsed = false;

    LazyJwtToken(String token) {
        this.token = token;
    }

    public Map<String, Object> getHeaders() {
        this.parse();
        return this.headers;
    }

    public Map<String, Object> getClaims() {
        this.parse();
        return this.claims;
    }

    private void parse() {
        if (!this.parsed) {
            this.parsed = true;
            try {
                JWT jwt = JWTParser.parse((String)this.token);
                this.headers = jwt.getHeader().toJSONObject();
                this.claims = jwt.getJWTClaimsSet().getClaims();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }
}

