/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.security.oauth2;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.security.core.AuthenticationContext;
import io.gravitee.gateway.security.core.AuthenticationHandler;
import io.gravitee.gateway.security.core.AuthenticationPolicy;
import io.gravitee.gateway.security.core.LazyJwtToken;
import io.gravitee.gateway.security.core.TokenExtractor;
import io.gravitee.gateway.security.oauth2.policy.CheckSubscriptionPolicy;
import java.util.Arrays;
import java.util.List;

public class OAuth2AuthenticationHandler
implements AuthenticationHandler {
    static final String AUTHENTICATION_HANDLER_NAME = "oauth2";
    static final String BEARER_AUTHORIZATION_TYPE = "Bearer";
    static final String JWT_CONTEXT_ATTRIBUTE = "jwt";
    private static final List<AuthenticationPolicy> POLICIES = Arrays.asList(() -> "oauth2", () -> CheckSubscriptionPolicy.class);

    public boolean canHandle(AuthenticationContext context) {
        String token = this.readToken(context.request());
        if (token == null || token.isEmpty()) {
            return false;
        }
        context.setInternalAttribute("auth.tokenIdentifiedInRequest", (Object)true);
        if (context.get(JWT_CONTEXT_ATTRIBUTE) == null) {
            context.set(JWT_CONTEXT_ATTRIBUTE, (Object)new LazyJwtToken(token));
        }
        return true;
    }

    private String readToken(Request request) {
        return TokenExtractor.extract((Request)request);
    }

    public String name() {
        return AUTHENTICATION_HANDLER_NAME;
    }

    public int order() {
        return 100;
    }

    public List<AuthenticationPolicy> handle(ExecutionContext executionContext) {
        return POLICIES;
    }

    public String tokenType() {
        return "AuthorizationBearer";
    }
}

