/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.security.oauth2.policy;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.policy.Policy;
import io.gravitee.gateway.policy.PolicyException;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.PolicyResult;
import io.gravitee.reporter.api.http.SecurityType;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.api.search.SubscriptionCriteria;
import io.gravitee.repository.management.model.Subscription;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class CheckSubscriptionPolicy
implements Policy {
    static final String CONTEXT_ATTRIBUTE_PLAN_SELECTION_RULE_BASED = "gravitee.attribute.gravitee.attribute.plan.selection.rule.based";
    static final String CONTEXT_ATTRIBUTE_CLIENT_ID = "oauth.client_id";
    static final String BEARER_AUTHORIZATION_TYPE = "Bearer";
    private static final String OAUTH2_ERROR_ACCESS_DENIED = "access_denied";
    private static final String OAUTH2_ERROR_SERVER_ERROR = "server_error";
    static final String GATEWAY_OAUTH2_ACCESS_DENIED_KEY = "GATEWAY_OAUTH2_ACCESS_DENIED";
    static final String GATEWAY_OAUTH2_SERVER_ERROR_KEY = "GATEWAY_OAUTH2_SERVER_ERROR";
    static final String GATEWAY_OAUTH2_INVALID_CLIENT_KEY = "GATEWAY_OAUTH2_INVALID_CLIENT";

    public void execute(PolicyChain policyChain, ExecutionContext executionContext) throws PolicyException {
        SubscriptionRepository subscriptionRepository = (SubscriptionRepository)executionContext.getComponent(SubscriptionRepository.class);
        String clientId = (String)executionContext.getAttribute(CONTEXT_ATTRIBUTE_CLIENT_ID);
        if (clientId == null || clientId.trim().isEmpty()) {
            this.sendError(GATEWAY_OAUTH2_INVALID_CLIENT_KEY, executionContext.response(), policyChain, "invalid_client", "No client_id was supplied");
            return;
        }
        executionContext.request().metrics().setSecurityType(SecurityType.OAUTH2);
        executionContext.request().metrics().setSecurityToken(clientId);
        String api = (String)executionContext.getAttribute("gravitee.attribute.api");
        try {
            List subscriptions = subscriptionRepository.search(new SubscriptionCriteria.Builder().apis(Collections.singleton(api)).clientId(clientId).status(Subscription.Status.ACCEPTED).build());
            if (subscriptions != null && !subscriptions.isEmpty()) {
                Subscription subscription;
                String plan = (String)executionContext.getAttribute("gravitee.attribute.plan");
                boolean selectionRuleBasedPlan = Boolean.TRUE.equals(executionContext.getAttribute(CONTEXT_ATTRIBUTE_PLAN_SELECTION_RULE_BASED));
                Subscription subscription2 = subscription = !selectionRuleBasedPlan ? (Subscription)subscriptions.get(0) : (Subscription)subscriptions.stream().filter(sub -> sub.getPlan().equals(plan)).findAny().orElse(null);
                if (subscription != null && subscription.getClientId().equals(clientId) && (subscription.getEndingAt() == null || subscription.getEndingAt().after(new Date(executionContext.request().timestamp())))) {
                    executionContext.setAttribute("gravitee.attribute.application", (Object)subscription.getApplication());
                    executionContext.setAttribute("gravitee.attribute.user-id", (Object)subscription.getId());
                    executionContext.setAttribute("gravitee.attribute.plan", (Object)subscription.getPlan());
                    policyChain.doNext(executionContext.request(), executionContext.response());
                    return;
                }
            }
            this.sendUnauthorized(GATEWAY_OAUTH2_ACCESS_DENIED_KEY, policyChain, OAUTH2_ERROR_ACCESS_DENIED);
        }
        catch (TechnicalException te) {
            this.sendUnauthorized(GATEWAY_OAUTH2_SERVER_ERROR_KEY, policyChain, OAUTH2_ERROR_SERVER_ERROR);
        }
    }

    private void sendUnauthorized(String key, PolicyChain policyChain, String description) {
        policyChain.failWith(PolicyResult.failure((String)key, (int)401, (String)description));
    }

    private void sendError(String key, Response response, PolicyChain policyChain, String error, String description) {
        String headerValue = "Bearer realm=\"gravitee.io\", error=\"" + error + "\", error_description=\"" + description + "\"";
        response.headers().add("WWW-Authenticate", headerValue);
        policyChain.failWith(PolicyResult.failure((String)key, (int)401, null));
    }

    public String id() {
        return "check-subscription";
    }
}

