/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.security.apikey;

import io.gravitee.definition.model.Api;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.service.ApiKeyService;
import io.gravitee.gateway.core.component.ComponentProvider;
import io.gravitee.gateway.core.component.ComponentResolver;
import io.gravitee.gateway.security.core.AuthenticationContext;
import io.gravitee.gateway.security.core.AuthenticationHandler;
import io.gravitee.gateway.security.core.AuthenticationPolicy;
import io.gravitee.reporter.api.http.SecurityType;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class ApiKeyAuthenticationHandler
implements AuthenticationHandler,
ComponentResolver {
    private final Logger logger = LoggerFactory.getLogger(ApiKeyAuthenticationHandler.class);
    static final String API_KEY_POLICY = "api-key";
    private static final String APIKEY_CONTEXT_ATTRIBUTE = "apikey";
    private static final List<AuthenticationPolicy> POLICIES = Arrays.asList(() -> "api-key");
    private String apiKeyHeader;
    private String apiKeyQueryParameter;
    private Api api;
    private ApiKeyService apiKeyService;

    public boolean canHandle(AuthenticationContext context) {
        String apiKey = this.readApiKey(context.request());
        if (apiKey == null) {
            return false;
        }
        context.setInternalAttribute("auth.tokenIdentifiedInRequest", (Object)true);
        if (this.apiKeyService != null && context.get(APIKEY_CONTEXT_ATTRIBUTE) == null) {
            Optional optApiKey = this.apiKeyService.getByApiAndKey(this.api.getId(), apiKey);
            if (optApiKey.isPresent()) {
                context.request().metrics().setSecurityType(SecurityType.API_KEY);
                context.request().metrics().setSecurityToken(apiKey);
            }
            context.set(APIKEY_CONTEXT_ATTRIBUTE, (Object)optApiKey);
        }
        return true;
    }

    public String name() {
        return "api_key";
    }

    public int order() {
        return 500;
    }

    public List<AuthenticationPolicy> handle(ExecutionContext executionContext) {
        return POLICIES;
    }

    private String readApiKey(Request request) {
        String apiKey = null;
        this.logger.debug("Looking for an API Key from request header: {}", (Object)this.apiKeyHeader);
        if (request.headers().contains(this.apiKeyHeader) && (apiKey = request.headers().get((CharSequence)this.apiKeyHeader)) == null) {
            apiKey = "";
        }
        if (apiKey == null) {
            this.logger.debug("Looking for an API Key from request query parameter: {}", (Object)this.apiKeyQueryParameter);
            if (request.parameters().containsKey((Object)this.apiKeyQueryParameter) && (apiKey = (String)request.parameters().getFirst((Object)this.apiKeyQueryParameter)) == null) {
                apiKey = "";
            }
        }
        return apiKey;
    }

    public void resolve(ComponentProvider componentProvider) {
        this.apiKeyService = (ApiKeyService)componentProvider.getComponent(ApiKeyService.class);
        this.api = (Api)componentProvider.getComponent(Api.class);
        Environment environment = (Environment)componentProvider.getComponent(Environment.class);
        this.apiKeyHeader = environment.getProperty("policy.api-key.header", "X-Gravitee-Api-Key");
        this.apiKeyQueryParameter = environment.getProperty("policy.api-key.param", API_KEY_POLICY);
    }

    public String tokenType() {
        return "ApiKey";
    }
}

