/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.security.apikey;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.Plan;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.api.service.ApiKeyService;
import io.gravitee.gateway.core.component.ComponentProvider;
import io.gravitee.gateway.core.component.ComponentResolver;
import io.gravitee.gateway.security.core.AuthenticationContext;
import io.gravitee.gateway.security.core.AuthenticationHandler;
import io.gravitee.gateway.security.core.AuthenticationPolicy;
import io.gravitee.reporter.api.http.SecurityType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class ApiKeyAuthenticationHandler
implements AuthenticationHandler,
ComponentResolver {
    private final Logger logger = LoggerFactory.getLogger(ApiKeyAuthenticationHandler.class);
    static final String API_KEY_POLICY = "api-key";
    private static final String APIKEY_CONTEXT_ATTRIBUTE = "apikey";
    private static final String CUSTOM_API_KEY_HEADER_FIELD = "/apiKeyHeader";
    private static final String ENABLE_CUSTOM_API_KEY_HEADER_FIELD = "/enableCustomApiKeyHeader";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final List<AuthenticationPolicy> POLICIES = Arrays.asList(() -> "api-key");
    private String apiKeyHeader;
    private List<String> customApiKeyHeaders;
    private String apiKeyQueryParameter;
    private Api api;
    private ApiKeyService apiKeyService;

    public boolean canHandle(AuthenticationContext context) {
        String apiKey = this.readApiKey(context.request());
        if (apiKey == null) {
            return false;
        }
        context.setInternalAttribute("auth.tokenIdentifiedInRequest", (Object)true);
        if (this.apiKeyService != null && context.get(APIKEY_CONTEXT_ATTRIBUTE) == null) {
            Optional optApiKey = this.apiKeyService.getByApiAndKey(this.api.getId(), apiKey);
            if (optApiKey.isPresent()) {
                context.request().metrics().setSecurityType(SecurityType.API_KEY);
                context.request().metrics().setSecurityToken(apiKey);
            }
            context.set(APIKEY_CONTEXT_ATTRIBUTE, (Object)optApiKey);
        }
        return true;
    }

    public String name() {
        return "api_key";
    }

    public int order() {
        return 500;
    }

    public List<AuthenticationPolicy> handle(ExecutionContext executionContext) {
        return POLICIES;
    }

    private String readApiKey(Request request) {
        String apiKey = null;
        Optional<String> apiKeyFromCustomHeader = this.customApiKeyHeaders.stream().map(arg_0 -> ((HttpHeaders)request.headers()).get(arg_0)).filter(Objects::nonNull).findFirst();
        if (apiKeyFromCustomHeader.isPresent()) {
            this.logger.debug("Found API Key from custom header for API {}", (Object)this.api.getId());
            return apiKeyFromCustomHeader.get();
        }
        if (!this.customApiKeyHeaders.isEmpty()) {
            if (this.customApiKeyHeaders.stream().noneMatch(arg_0 -> ((HttpHeaders)request.headers()).contains(arg_0))) {
                return "";
            }
        }
        this.logger.debug("Looking for an API Key from request header: {}", (Object)this.apiKeyHeader);
        if (request.headers().contains(this.apiKeyHeader) && (apiKey = request.headers().get((CharSequence)this.apiKeyHeader)) == null) {
            apiKey = "";
        }
        if (apiKey == null) {
            this.logger.debug("Looking for an API Key from request query parameter: {}", (Object)this.apiKeyQueryParameter);
            if (request.parameters().containsKey((Object)this.apiKeyQueryParameter) && (apiKey = (String)request.parameters().getFirst((Object)this.apiKeyQueryParameter)) == null) {
                apiKey = "";
            }
        }
        return apiKey;
    }

    private List<String> getCustomApiKeyHeadersFromPlans() {
        if (this.api != null && this.api.getPlans() != null) {
            return this.api.getPlans().stream().filter(Plan::isApiKey).filter(plan -> StringUtils.hasText((String)plan.getSecurityDefinition())).map(plan -> {
                try {
                    String headerName;
                    JsonNode securityDef = objectMapper.readTree(plan.getSecurityDefinition());
                    if (securityDef != null && securityDef.at(ENABLE_CUSTOM_API_KEY_HEADER_FIELD).asBoolean() && StringUtils.hasText((String)(headerName = securityDef.at(CUSTOM_API_KEY_HEADER_FIELD).asText()))) {
                        return headerName;
                    }
                }
                catch (JsonProcessingException e) {
                    this.logger.warn("Unable to parse security definition for plan {}", (Object)plan.getId(), (Object)e);
                }
                return null;
            }).filter(Objects::nonNull).toList();
        }
        return Collections.emptyList();
    }

    public void resolve(ComponentProvider componentProvider) {
        this.apiKeyService = (ApiKeyService)componentProvider.getComponent(ApiKeyService.class);
        this.api = (Api)componentProvider.getComponent(Api.class);
        Environment environment = (Environment)componentProvider.getComponent(Environment.class);
        this.apiKeyHeader = environment.getProperty("policy.api-key.header", "X-Gravitee-Api-Key");
        this.apiKeyQueryParameter = environment.getProperty("policy.api-key.param", API_KEY_POLICY);
        this.customApiKeyHeaders = this.getCustomApiKeyHeadersFromPlans();
    }

    public String tokenType() {
        return "ApiKey";
    }
}

