/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.resource.internal.legacy;

import io.gravitee.common.component.AbstractLifecycleComponent;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.gateway.reactor.Reactable;
import io.gravitee.gateway.resource.ResourceConfigurationFactory;
import io.gravitee.gateway.resource.ResourceLifecycleManager;
import io.gravitee.gateway.resource.internal.ResourceFactory;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoader;
import io.gravitee.plugin.resource.ResourceClassLoaderFactory;
import io.gravitee.plugin.resource.ResourcePlugin;
import io.gravitee.resource.api.ResourceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ClassUtils;

public class LegacyResourceManagerImpl
extends AbstractLifecycleComponent<ResourceManager>
implements ResourceLifecycleManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<String, io.gravitee.resource.api.Resource> resources = new HashMap<String, io.gravitee.resource.api.Resource>();
    private final Map<String, PluginClassLoader> classloaders = new HashMap<String, PluginClassLoader>();
    protected final Reactable reactable;
    protected final ConfigurablePluginManager<ResourcePlugin<?>> resourcePluginManager;
    protected final ResourceClassLoaderFactory resourceClassLoaderFactory;
    protected final ResourceConfigurationFactory resourceConfigurationFactory;
    protected final ApplicationContext applicationContext;

    public LegacyResourceManagerImpl(Reactable reactable, ConfigurablePluginManager<ResourcePlugin<?>> resourcePluginManager, ResourceClassLoaderFactory resourceClassLoaderFactory, ResourceConfigurationFactory resourceConfigurationFactory, ApplicationContext applicationContext) {
        this.reactable = reactable;
        this.resourcePluginManager = resourcePluginManager;
        this.resourceClassLoaderFactory = resourceClassLoaderFactory;
        this.resourceConfigurationFactory = resourceConfigurationFactory;
        this.applicationContext = applicationContext;
    }

    protected void doStart() throws Exception {
        this.initialize();
        this.resources.entrySet().stream().forEach(resource -> {
            try {
                this.logger.info("Start resource {} [{}]", resource.getKey(), (Object)((io.gravitee.resource.api.Resource)resource.getValue()).getClass());
                ((io.gravitee.resource.api.Resource)resource.getValue()).start();
            }
            catch (Exception ex) {
                this.logger.error("Unable to start resource", (Throwable)ex);
            }
        });
    }

    protected void doStop() throws Exception {
        this.resources.entrySet().stream().forEach(resource -> {
            try {
                this.logger.info("Stop resource {} [{}]", resource.getKey(), (Object)((io.gravitee.resource.api.Resource)resource.getValue()).getClass());
                ((io.gravitee.resource.api.Resource)resource.getValue()).stop();
            }
            catch (Exception ex) {
                this.logger.error("Unable to stop resource", (Throwable)ex);
            }
        });
        this.resources.values().forEach(resource -> {
            ClassLoader resourceClassLoader = resource.getClass().getClassLoader();
            if (resourceClassLoader instanceof PluginClassLoader) {
                try {
                    ((PluginClassLoader)resourceClassLoader).close();
                }
                catch (IOException ioe) {
                    this.logger.error("Unable to close classloader for resource {}", (Object)resource.getClass(), (Object)ioe);
                }
            }
        });
        this.resources.clear();
    }

    protected void initialize() {
        Set resourceDeps = this.reactable.dependencies(Resource.class);
        resourceDeps.forEach(resource -> {
            block7: {
                ResourcePlugin resourcePlugin = (ResourcePlugin)this.resourcePluginManager.get(resource.getType());
                if (resourcePlugin == null) {
                    this.logger.error("Resource [{}] cannot be found in plugin registry", (Object)resource.getType());
                    throw new IllegalStateException("Resource [" + resource.getType() + "] cannot be found in plugin registry");
                }
                PluginClassLoader resourceClassLoader = this.classloaders.computeIfAbsent(resourcePlugin.id(), s -> this.resourceClassLoaderFactory.getOrCreateClassLoader((Plugin)resourcePlugin, this.reactable.getClass().getClassLoader()));
                this.logger.debug("Loading resource {} for {}", (Object)resource.getName(), (Object)this.reactable);
                try {
                    io.gravitee.resource.api.Resource resourceInstance;
                    Class resourceClass = ClassUtils.forName((String)resourcePlugin.resource().getName(), (ClassLoader)resourceClassLoader);
                    HashMap injectables = new HashMap();
                    if (resourcePlugin.configuration() != null) {
                        Class resourceConfigurationClass = ClassUtils.forName((String)resourcePlugin.configuration().getName(), (ClassLoader)resourceClassLoader);
                        injectables.put(resourceConfigurationClass, this.resourceConfigurationFactory.create(resourceConfigurationClass, resource.getConfiguration()));
                    }
                    if ((resourceInstance = new ResourceFactory().create(resourceClass, injectables)) instanceof ApplicationContextAware) {
                        ((ApplicationContextAware)resourceInstance).setApplicationContext(this.applicationContext);
                    }
                    this.resources.put(resource.getName(), resourceInstance);
                }
                catch (Exception ex) {
                    this.logger.error("Unable to create resource", (Throwable)ex);
                    if (resourceClassLoader == null) break block7;
                    try {
                        resourceClassLoader.close();
                    }
                    catch (IOException ioe) {
                        this.logger.error("Unable to close classloader for resource", (Throwable)ioe);
                    }
                }
            }
        });
    }

    public Object getResource(String name) {
        return this.resources.get(name);
    }

    public <T> T getResource(Class<T> requiredType) {
        Optional<io.gravitee.resource.api.Resource> resource = this.resources.values().stream().filter(resourceEntry -> resourceEntry.getClass().isAssignableFrom(requiredType)).findFirst();
        return resource.orElse(null);
    }

    public <T> T getResource(String name, Class<T> requiredType) {
        Object resource = this.getResource(name);
        if (resource == null) {
            return null;
        }
        if (requiredType.isAssignableFrom(resource.getClass())) {
            return (T)resource;
        }
        throw new IllegalArgumentException("Required type parameter does not match the resource type");
    }

    public Class<?> getType(String name) {
        io.gravitee.resource.api.Resource resource = (io.gravitee.resource.api.Resource)this.getResource(name);
        if (resource != null) {
            return resource.getClass();
        }
        return null;
    }

    public boolean containsResource(String name) {
        return this.resources.containsKey(name);
    }

    @Override
    public Collection<? extends io.gravitee.resource.api.Resource> getResources() {
        return new ArrayList<io.gravitee.resource.api.Resource>(this.resources.values());
    }
}

