/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.resource.internal;

import io.gravitee.gateway.core.classloader.DefaultClassLoader;
import io.gravitee.gateway.reactive.api.context.DeploymentContext;
import io.gravitee.gateway.reactor.Reactable;
import io.gravitee.gateway.resource.ResourceConfigurationFactory;
import io.gravitee.gateway.resource.internal.ResourceLoader;
import io.gravitee.gateway.resource.internal.legacy.LegacyResourceManagerImpl;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.resource.ResourceClassLoaderFactory;
import io.gravitee.plugin.resource.ResourcePlugin;
import io.gravitee.resource.api.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ResourceManagerImpl
extends LegacyResourceManagerImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceManagerImpl.class);
    private final boolean legacyMode;
    private final ResourceLoader resourceLoader;

    public ResourceManagerImpl(boolean legacyMode, DefaultClassLoader classLoader, Reactable reactable, ConfigurablePluginManager<ResourcePlugin<?>> resourcePluginManager, ResourceClassLoaderFactory resourceClassLoaderFactory, ResourceConfigurationFactory resourceConfigurationFactory, ApplicationContext applicationContext, DeploymentContext deploymentContext) {
        super(reactable, resourcePluginManager, resourceClassLoaderFactory, resourceConfigurationFactory, applicationContext);
        this.legacyMode = legacyMode;
        this.resourceLoader = new ResourceLoader(classLoader, resourcePluginManager, resourceClassLoaderFactory, resourceConfigurationFactory, applicationContext, deploymentContext);
    }

    @Override
    protected void initialize() {
        if (this.legacyMode) {
            super.initialize();
        } else {
            this.reactable.dependencies(io.gravitee.definition.model.plugins.resources.Resource.class).forEach(resource -> {
                log.debug("Loading resource {} for {}", (Object)resource.getName(), (Object)this.reactable);
                Resource resourceInstance = this.resourceLoader.load(resource.getType(), resource.getConfiguration());
                if (resourceInstance != null) {
                    this.resources.put(resource.getName(), resourceInstance);
                }
            });
        }
    }
}

