/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.resource.internal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.gateway.resource.ResourceConfigurationFactory;
import io.gravitee.resource.api.ResourceConfiguration;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceConfigurationFactoryImpl
implements ResourceConfigurationFactory {
    private final Logger LOGGER = LoggerFactory.getLogger(ResourceConfigurationFactoryImpl.class);
    private static final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    @Override
    public <T extends ResourceConfiguration> T create(Class<T> resourceConfigurationClass, String configuration) {
        if (configuration == null || configuration.isEmpty()) {
            this.LOGGER.error("Unable to create a resource configuration from a null or empty configuration data");
            return null;
        }
        try {
            return (T)((ResourceConfiguration)mapper.readValue(configuration, resourceConfigurationClass));
        }
        catch (IOException ex) {
            this.LOGGER.error("Unable to instance resource configuration for {}", (Object)resourceConfigurationClass.getName(), (Object)ex);
            return null;
        }
    }
}

