/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.resource.internal;

import io.gravitee.gateway.core.classloader.DefaultClassLoader;
import io.gravitee.gateway.reactive.api.context.DeploymentContext;
import io.gravitee.gateway.resource.ResourceConfigurationFactory;
import io.gravitee.gateway.resource.internal.ResourceFactory;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.resource.ResourceClassLoaderFactory;
import io.gravitee.plugin.resource.ResourcePlugin;
import io.gravitee.resource.api.Resource;
import java.io.IOException;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ClassUtils;

public class ResourceLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceLoader.class);
    private final DefaultClassLoader classLoader;
    private final ConfigurablePluginManager<ResourcePlugin<?>> resourcePluginManager;
    private final ResourceClassLoaderFactory resourceClassLoaderFactory;
    private final ResourceConfigurationFactory resourceConfigurationFactory;
    private final ApplicationContext applicationContext;
    private final DeploymentContext deploymentContext;

    public ResourceLoader(DefaultClassLoader classLoader, ConfigurablePluginManager<ResourcePlugin<?>> resourcePluginManager, ResourceClassLoaderFactory resourceClassLoaderFactory, ResourceConfigurationFactory resourceConfigurationFactory, ApplicationContext applicationContext, DeploymentContext deploymentContext) {
        this.classLoader = classLoader;
        this.resourcePluginManager = resourcePluginManager;
        this.resourceClassLoaderFactory = resourceClassLoaderFactory;
        this.resourceConfigurationFactory = resourceConfigurationFactory;
        this.applicationContext = applicationContext;
        this.deploymentContext = deploymentContext;
    }

    public Resource load(String resourceType, String resourceConfiguration) {
        ResourcePlugin resourcePlugin = (ResourcePlugin)this.resourcePluginManager.get(resourceType);
        if (resourcePlugin == null) {
            throw new IllegalStateException("Resource [" + resourceType + "] cannot be found in plugin registry");
        }
        this.classLoader.addClassLoader(resourcePlugin.resource().getCanonicalName(), () -> this.resourceClassLoaderFactory.getOrCreateClassLoader((Plugin)resourcePlugin, (ClassLoader)this.classLoader));
        try {
            Resource resourceInstance;
            Class resourceClass = ClassUtils.forName((String)resourcePlugin.resource().getName(), (ClassLoader)this.classLoader);
            HashMap injectables = new HashMap();
            injectables.put(DeploymentContext.class, this.deploymentContext);
            if (resourcePlugin.configuration() != null) {
                Class resourceConfigurationClass = ClassUtils.forName((String)resourcePlugin.configuration().getName(), (ClassLoader)this.classLoader);
                injectables.put(resourceConfigurationClass, this.resourceConfigurationFactory.create(resourceConfigurationClass, resourceConfiguration));
            }
            if ((resourceInstance = new ResourceFactory().create(resourceClass, injectables)) instanceof ApplicationContextAware) {
                ((ApplicationContextAware)resourceInstance).setApplicationContext(this.applicationContext);
            }
            return resourceInstance;
        }
        catch (Exception ex) {
            log.error("Unable to create resource", (Throwable)ex);
            try {
                this.classLoader.removeClassLoader(resourcePlugin.resource().getCanonicalName());
            }
            catch (IOException ioe) {
                log.error("Unable to close classloader for resource", (Throwable)ioe);
            }
            return null;
        }
    }
}

