/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.resource.internal;

import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.gateway.core.classloader.DefaultClassLoader;
import io.gravitee.gateway.reactor.Reactable;
import io.gravitee.gateway.resource.ResourceConfigurationFactory;
import io.gravitee.gateway.resource.internal.ResourceFactory;
import io.gravitee.gateway.resource.internal.legacy.LegacyResourceManagerImpl;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.resource.ResourceClassLoaderFactory;
import io.gravitee.plugin.resource.ResourcePlugin;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ClassUtils;

public class ResourceManagerImpl
extends LegacyResourceManagerImpl {
    private final boolean legacyMode;
    private final DefaultClassLoader classLoader;

    public ResourceManagerImpl(boolean legacyMode, DefaultClassLoader classLoader, Reactable reactable, ConfigurablePluginManager<ResourcePlugin<?>> resourcePluginManager, ResourceClassLoaderFactory resourceClassLoaderFactory, ResourceConfigurationFactory resourceConfigurationFactory, ApplicationContext applicationContext) {
        super(reactable, resourcePluginManager, resourceClassLoaderFactory, resourceConfigurationFactory, applicationContext);
        this.legacyMode = legacyMode;
        this.classLoader = classLoader;
    }

    @Override
    protected void initialize() {
        if (this.legacyMode) {
            super.initialize();
        } else {
            Set resourceDeps = this.reactable.dependencies(Resource.class);
            resourceDeps.forEach(resource -> {
                ResourcePlugin resourcePlugin = (ResourcePlugin)this.resourcePluginManager.get(resource.getType());
                if (resourcePlugin == null) {
                    this.logger.error("Resource [{}] can not be found in plugin registry", (Object)resource.getType());
                    throw new IllegalStateException("Resource [" + resource.getType() + "] can not be found in plugin registry");
                }
                this.classLoader.addClassLoader(resourcePlugin.resource().getCanonicalName(), () -> this.resourceClassLoaderFactory.getOrCreateClassLoader((Plugin)resourcePlugin, this.reactable.getClass().getClassLoader()));
                this.logger.debug("Loading resource {} for {}", (Object)resource.getName(), (Object)this.reactable);
                try {
                    io.gravitee.resource.api.Resource resourceInstance;
                    Class resourceClass = ClassUtils.forName((String)resourcePlugin.resource().getName(), (ClassLoader)this.classLoader);
                    HashMap injectables = new HashMap();
                    if (resourcePlugin.configuration() != null) {
                        Class resourceConfigurationClass = ClassUtils.forName((String)resourcePlugin.configuration().getName(), (ClassLoader)this.classLoader);
                        injectables.put(resourceConfigurationClass, this.resourceConfigurationFactory.create(resourceConfigurationClass, resource.getConfiguration()));
                    }
                    if ((resourceInstance = new ResourceFactory().create(resourceClass, injectables)) instanceof ApplicationContextAware) {
                        ((ApplicationContextAware)resourceInstance).setApplicationContext(this.applicationContext);
                    }
                    this.resources.put(resource.getName(), resourceInstance);
                }
                catch (Exception ex) {
                    this.logger.error("Unable to create resource", (Throwable)ex);
                    try {
                        this.classLoader.removeClassLoader(resourcePlugin.resource().getCanonicalName());
                    }
                    catch (IOException ioe) {
                        this.logger.error("Unable to close classloader for resource", (Throwable)ioe);
                    }
                }
            });
        }
    }
}

