/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.resource.internal;

import io.gravitee.common.component.AbstractLifecycleComponent;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.gateway.reactor.Reactable;
import io.gravitee.gateway.reactor.handler.ReactorHandler;
import io.gravitee.gateway.resource.ResourceConfigurationFactory;
import io.gravitee.gateway.resource.ResourceLifecycleManager;
import io.gravitee.gateway.resource.internal.ResourceFactory;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoader;
import io.gravitee.plugin.resource.ResourceClassLoaderFactory;
import io.gravitee.plugin.resource.ResourcePlugin;
import io.gravitee.resource.api.ResourceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;

public class ResourceManagerImpl
extends AbstractLifecycleComponent<ResourceManager>
implements ResourceLifecycleManager {
    private final Logger logger = LoggerFactory.getLogger(ResourceManagerImpl.class);
    @Autowired
    private ApplicationContext applicationContext;
    private final Map<String, io.gravitee.resource.api.Resource> resources = new HashMap<String, io.gravitee.resource.api.Resource>();
    private final Map<String, PluginClassLoader> classloaders = new HashMap<String, PluginClassLoader>();

    protected void doStart() throws Exception {
        this.initialize();
        this.resources.entrySet().stream().forEach(resource -> {
            try {
                this.logger.info("Start resource {} [{}]", resource.getKey(), ((io.gravitee.resource.api.Resource)resource.getValue()).getClass());
                ((io.gravitee.resource.api.Resource)resource.getValue()).start();
            }
            catch (Exception ex) {
                this.logger.error("Unable to start resource", (Throwable)ex);
            }
        });
    }

    protected void doStop() throws Exception {
        this.resources.entrySet().stream().forEach(resource -> {
            try {
                this.logger.info("Stop resource {} [{}]", resource.getKey(), ((io.gravitee.resource.api.Resource)resource.getValue()).getClass());
                ((io.gravitee.resource.api.Resource)resource.getValue()).stop();
            }
            catch (Exception ex) {
                this.logger.error("Unable to stop resource", (Throwable)ex);
            }
        });
        this.resources.values().forEach(resource -> {
            ClassLoader resourceClassLoader = resource.getClass().getClassLoader();
            if (resourceClassLoader instanceof PluginClassLoader) {
                try {
                    ((PluginClassLoader)resourceClassLoader).close();
                }
                catch (IOException ioe) {
                    this.logger.error("Unable to close classloader for resource {}", resource.getClass(), (Object)ioe);
                }
            }
        });
        this.resources.clear();
    }

    public ApplicationContext getRootContext() {
        ApplicationContext rootContext = this.applicationContext;
        while (rootContext.getParent() != null) {
            rootContext = rootContext.getParent();
        }
        return rootContext;
    }

    private void initialize() {
        String[] beanNamesForType = this.getRootContext().getBeanNamesForType(ResolvableType.forClassWithGenerics(ConfigurablePluginManager.class, (Class[])new Class[]{ResourcePlugin.class}));
        ConfigurablePluginManager rpm = (ConfigurablePluginManager)this.getRootContext().getBean(beanNamesForType[0]);
        ResourceClassLoaderFactory rclf = (ResourceClassLoaderFactory)this.applicationContext.getBean(ResourceClassLoaderFactory.class);
        ResourceConfigurationFactory rcf = (ResourceConfigurationFactory)this.applicationContext.getBean(ResourceConfigurationFactory.class);
        ReactorHandler rh = (ReactorHandler)this.applicationContext.getBean(ReactorHandler.class);
        Reactable reactable = (Reactable)this.applicationContext.getBean(Reactable.class);
        Set resourceDeps = reactable.dependencies(Resource.class);
        resourceDeps.forEach(resource -> {
            block7: {
                ResourcePlugin resourcePlugin = (ResourcePlugin)rpm.get(resource.getType());
                if (resourcePlugin == null) {
                    this.logger.error("Resource [{}] can not be found in plugin registry", (Object)resource.getType());
                    throw new IllegalStateException("Resource [" + resource.getType() + "] can not be found in plugin registry");
                }
                PluginClassLoader resourceClassLoader = this.classloaders.computeIfAbsent(resourcePlugin.id(), s -> rclf.getOrCreateClassLoader((Plugin)resourcePlugin, rh.getClass().getClassLoader()));
                this.logger.debug("Loading resource {} for {}", (Object)resource.getName(), (Object)rh);
                try {
                    io.gravitee.resource.api.Resource resourceInstance;
                    Class resourceClass = ClassUtils.forName((String)resourcePlugin.resource().getName(), (ClassLoader)resourceClassLoader);
                    HashMap injectables = new HashMap();
                    if (resourcePlugin.configuration() != null) {
                        Class resourceConfigurationClass = ClassUtils.forName((String)resourcePlugin.configuration().getName(), (ClassLoader)resourceClassLoader);
                        injectables.put(resourceConfigurationClass, rcf.create(resourceConfigurationClass, resource.getConfiguration()));
                    }
                    if ((resourceInstance = new ResourceFactory().create(resourceClass, injectables)) instanceof ApplicationContextAware) {
                        ((ApplicationContextAware)resourceInstance).setApplicationContext(this.applicationContext);
                    }
                    this.resources.put(resource.getName(), resourceInstance);
                }
                catch (Exception ex) {
                    this.logger.error("Unable to create resource", (Throwable)ex);
                    if (resourceClassLoader == null) break block7;
                    try {
                        resourceClassLoader.close();
                    }
                    catch (IOException ioe) {
                        this.logger.error("Unable to close classloader for resource", (Throwable)ioe);
                    }
                }
            }
        });
    }

    public Object getResource(String name) {
        return this.resources.get(name);
    }

    public <T> T getResource(Class<T> requiredType) {
        Optional<io.gravitee.resource.api.Resource> resource = this.resources.values().stream().filter(resourceEntry -> resourceEntry.getClass().isAssignableFrom(requiredType)).findFirst();
        return resource.orElse(null);
    }

    public <T> T getResource(String name, Class<T> requiredType) {
        Object resource = this.getResource(name);
        if (resource == null) {
            return null;
        }
        if (requiredType.isAssignableFrom(resource.getClass())) {
            return (T)resource;
        }
        throw new IllegalArgumentException("Required type parameter does not match the resource type");
    }

    public Class<?> getType(String name) {
        io.gravitee.resource.api.Resource resource = (io.gravitee.resource.api.Resource)this.getResource(name);
        if (resource != null) {
            return resource.getClass();
        }
        return null;
    }

    public boolean containsResource(String name) {
        return this.resources.containsKey(name);
    }

    @Override
    public Collection<? extends io.gravitee.resource.api.Resource> getResources() {
        return new ArrayList<io.gravitee.resource.api.Resource>(this.resources.values());
    }
}

