/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.resource.internal;

import com.google.common.base.Predicate;
import io.gravitee.resource.api.Resource;
import io.gravitee.resource.api.ResourceConfiguration;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceFactory.class);

    public Resource create(Class<? extends Resource> resourceClass, Map<Class<?>, Object> injectables) throws Exception {
        LOGGER.debug("Create a new resource instance for {}", (Object)resourceClass.getName());
        return this.createResource(resourceClass, injectables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource createResource(Class<? extends Resource> resourceClass, Map<Class<?>, Object> injectables) {
        Set<Field> fields;
        Resource resourceInst = null;
        Constructor<? extends Resource> constr = this.lookingForConstructor(resourceClass);
        if (constr != null) {
            try {
                resourceInst = constr.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                LOGGER.error("Unable to instantiate resource {}", resourceClass, (Object)ex);
            }
        }
        if (resourceInst != null && (fields = this.lookingForInjectableFields(resourceClass)) != null) {
            for (Field field : fields) {
                boolean accessible = field.isAccessible();
                Class<?> type = field.getType();
                Optional<Object> value = injectables.values().stream().filter(o -> type.isAssignableFrom(o.getClass())).findFirst();
                if (!value.isPresent()) continue;
                LOGGER.debug("Inject value into field {} [{}] in {}", new Object[]{field.getName(), type.getName(), resourceClass});
                try {
                    field.setAccessible(true);
                    field.set(resourceInst, value.get());
                }
                catch (IllegalAccessException iae) {
                    LOGGER.error("Unable to set field value for {} in {}", new Object[]{field.getName(), resourceClass, iae});
                }
                finally {
                    field.setAccessible(accessible);
                }
            }
        }
        return resourceInst;
    }

    private Constructor<? extends Resource> lookingForConstructor(Class<? extends Resource> resourceClass) {
        LOGGER.debug("Looking for a constructor to inject resource configuration");
        Constructor<? extends Resource> constructor = null;
        Set resourceConstructors = ReflectionUtils.getConstructors(resourceClass, (Predicate[])new Predicate[]{ReflectionUtils.withModifier((int)1), ResourceFactory.withParametersAssignableFrom(ResourceConfiguration.class), ReflectionUtils.withParametersCount((int)1)});
        if (resourceConstructors.isEmpty()) {
            LOGGER.debug("No configuration can be injected for {} because there is no valid constructor. Using default empty constructor.", (Object)resourceClass.getName());
            try {
                constructor = resourceClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                LOGGER.error("Unable to find default empty constructor for {}", (Object)resourceClass.getName(), (Object)nsme);
            }
        } else if (resourceConstructors.size() == 1) {
            constructor = (Constructor<? extends Resource>)resourceConstructors.iterator().next();
        } else {
            LOGGER.info("Too much constructors to instantiate resource {}", (Object)resourceClass.getName());
        }
        return constructor;
    }

    private Set<Field> lookingForInjectableFields(Class<?> resourceClass) {
        return ReflectionUtils.getAllFields(resourceClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Inject.class)});
    }

    public static Predicate<Member> withParametersAssignableFrom(Class ... types) {
        return input -> {
            Class[] parameterTypes;
            if (input != null && (parameterTypes = ResourceFactory.parameterTypes(input)).length == types.length) {
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (types[i].isAssignableFrom(parameterTypes[i]) && (parameterTypes[i] != Object.class || types[i] == Object.class)) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    private static Class[] parameterTypes(Member member) {
        return member != null ? (member.getClass() == Method.class ? ((Method)member).getParameterTypes() : (member.getClass() == Constructor.class ? ((Constructor)member).getParameterTypes() : null)) : null;
    }
}

