/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.platform.organization.reactor;

import io.gravitee.gateway.platform.organization.ReactableOrganization;
import io.gravitee.gateway.reactive.platform.organization.reactor.OrganizationReactor;
import io.gravitee.gateway.reactive.platform.organization.reactor.OrganizationReactorFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationReactorRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrganizationReactorRegistry.class);
    private final OrganizationReactorFactory organizationReactorFactory;
    private final Map<String, OrganizationReactor> registry = new ConcurrentHashMap<String, OrganizationReactor>();

    public OrganizationReactor get(String organizationId) {
        log.debug("Retrieving an OrganizationReactor for organization: {}", (Object)organizationId);
        return this.registry.get(organizationId);
    }

    public void create(ReactableOrganization reactableOrganization) {
        log.debug("Create a new OrganizationReactor for organization: {}", (Object)reactableOrganization.getId());
        try {
            OrganizationReactor organizationReactor = this.organizationReactorFactory.create(reactableOrganization);
            organizationReactor.start();
            OrganizationReactor previousOrganizationReactor = this.registry.put(organizationReactor.id(), organizationReactor);
            if (previousOrganizationReactor != null) {
                log.debug("The ReactableOrganization was already deployed; stopping previous OrganizationReactor for organization: {}", (Object)reactableOrganization.getId());
                previousOrganizationReactor.stop();
            }
        }
        catch (Exception ex) {
            log.error("Unable to create and start the new organization '{}' reactor", (Object)reactableOrganization.getId(), (Object)ex);
        }
    }

    public void remove(ReactableOrganization reactableOrganization) {
        log.debug("Removing an OrganizationReactor for organization: {}", (Object)reactableOrganization.getId());
        try {
            OrganizationReactor organizationReactor = this.registry.remove(reactableOrganization.getId());
            if (organizationReactor != null) {
                organizationReactor.stop();
            }
        }
        catch (Exception ex) {
            log.error("Unable to remove and stop the organization '{}' reactor", (Object)reactableOrganization.getId(), (Object)ex);
        }
    }

    public void clear() {
        this.registry.forEach((id, organizationReactor) -> {
            try {
                organizationReactor.stop();
            }
            catch (Exception ex) {
                log.error("Unable to remove and stop the organization '{}' reactor", id, (Object)ex);
            }
        });
        this.registry.clear();
    }

    @Generated
    public OrganizationReactorRegistry(OrganizationReactorFactory organizationReactorFactory) {
        this.organizationReactorFactory = organizationReactorFactory;
    }
}

