/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.platform.organization.policy;

import io.gravitee.definition.model.flow.Flow;
import io.gravitee.gateway.reactive.api.ExecutionPhase;
import io.gravitee.gateway.reactive.platform.organization.reactor.DefaultOrganizationReactor;
import io.gravitee.gateway.reactive.platform.organization.reactor.OrganizationReactor;
import io.gravitee.gateway.reactive.platform.organization.reactor.OrganizationReactorRegistry;
import io.gravitee.gateway.reactive.policy.HttpPolicyChain;
import io.gravitee.gateway.reactive.policy.PolicyChainFactory;
import lombok.Generated;

public class OrganizationPolicyChainFactory
implements PolicyChainFactory<HttpPolicyChain> {
    private final String organizationId;
    private final OrganizationReactorRegistry organizationReactorRegistry;

    public HttpPolicyChain create(String flowChainId, Flow flow, ExecutionPhase phase) {
        OrganizationReactor organizationReactor = this.organizationReactorRegistry.get(this.organizationId);
        if (organizationReactor instanceof DefaultOrganizationReactor) {
            DefaultOrganizationReactor defaultOrganizationReactor = (DefaultOrganizationReactor)organizationReactor;
            return (HttpPolicyChain)defaultOrganizationReactor.policyChainFactory().create(flowChainId, flow, phase);
        }
        throw new IllegalStateException(String.format("PolicyChainFactory.create() shouldn't be call if no OrganizationReactor has been registered for organization '%s'", this.organizationId));
    }

    @Generated
    public OrganizationPolicyChainFactory(String organizationId, OrganizationReactorRegistry organizationReactorRegistry) {
        this.organizationId = organizationId;
        this.organizationReactorRegistry = organizationReactorRegistry;
    }
}

