/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.platform.organization.reactor;

import io.gravitee.gateway.core.classloader.DefaultClassLoader;
import io.gravitee.gateway.core.component.ComponentProvider;
import io.gravitee.gateway.platform.organization.ReactableOrganization;
import io.gravitee.gateway.policy.PolicyConfigurationFactory;
import io.gravitee.gateway.policy.impl.CachedPolicyConfigurationFactory;
import io.gravitee.gateway.reactive.platform.organization.policy.OrganizationPolicyManager;
import io.gravitee.gateway.reactive.platform.organization.reactor.DefaultOrganizationReactor;
import io.gravitee.gateway.reactive.platform.organization.reactor.OrganizationReactor;
import io.gravitee.gateway.reactive.platform.organization.reactor.OrganizationReactorFactory;
import io.gravitee.gateway.reactive.policy.HttpPolicyChain;
import io.gravitee.gateway.reactive.policy.HttpPolicyChainFactory;
import io.gravitee.gateway.reactive.policy.PolicyChainFactory;
import io.gravitee.gateway.reactive.policy.PolicyFactoryManager;
import io.gravitee.gateway.reactive.policy.PolicyManager;
import io.gravitee.node.opentelemetry.configuration.OpenTelemetryConfiguration;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.policy.PolicyClassLoaderFactory;
import io.gravitee.plugin.policy.PolicyPlugin;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;

public class DefaultOrganizationReactorFactory
implements OrganizationReactorFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultOrganizationReactorFactory.class);
    protected final DefaultClassLoader defaultClassLoader;
    protected final ApplicationContext applicationContext;
    protected final PolicyFactoryManager policyFactoryManager;
    protected final PolicyClassLoaderFactory policyClassLoaderFactory;
    protected final ComponentProvider componentProvider;
    protected final OpenTelemetryConfiguration configuration;

    @Override
    public OrganizationReactor create(ReactableOrganization reactableOrganization) {
        OrganizationPolicyManager organizationPolicyManager = this.platformPolicyManager(reactableOrganization);
        HttpPolicyChainFactory policyChainFactory = this.policyChainFactory(reactableOrganization, organizationPolicyManager);
        return new DefaultOrganizationReactor(reactableOrganization, (PolicyChainFactory<HttpPolicyChain>)policyChainFactory, organizationPolicyManager);
    }

    protected HttpPolicyChainFactory policyChainFactory(ReactableOrganization reactableOrganization, OrganizationPolicyManager organizationPolicyManager) {
        return new HttpPolicyChainFactory("organization-" + reactableOrganization.getId(), (PolicyManager)organizationPolicyManager, this.configuration.isTracesEnabled());
    }

    protected OrganizationPolicyManager platformPolicyManager(ReactableOrganization reactableOrganization) {
        String[] beanNamesForType = this.applicationContext.getBeanNamesForType(ResolvableType.forClassWithGenerics(ConfigurablePluginManager.class, (Class[])new Class[]{PolicyPlugin.class}));
        ConfigurablePluginManager configurablePluginManager = (ConfigurablePluginManager)this.applicationContext.getBean(beanNamesForType[0]);
        return new OrganizationPolicyManager(this.defaultClassLoader, this.policyFactoryManager, (PolicyConfigurationFactory)new CachedPolicyConfigurationFactory(), configurablePluginManager, this.policyClassLoaderFactory, this.componentProvider, reactableOrganization);
    }

    @Generated
    public DefaultOrganizationReactorFactory(DefaultClassLoader defaultClassLoader, ApplicationContext applicationContext, PolicyFactoryManager policyFactoryManager, PolicyClassLoaderFactory policyClassLoaderFactory, ComponentProvider componentProvider, OpenTelemetryConfiguration configuration) {
        this.defaultClassLoader = defaultClassLoader;
        this.applicationContext = applicationContext;
        this.policyFactoryManager = policyFactoryManager;
        this.policyClassLoaderFactory = policyClassLoaderFactory;
        this.componentProvider = componentProvider;
        this.configuration = configuration;
    }
}

