/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.platform.organization.flow;

import io.gravitee.definition.model.flow.Flow;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.core.condition.CompositeConditionEvaluator;
import io.gravitee.gateway.core.condition.ConditionEvaluator;
import io.gravitee.gateway.flow.condition.ConditionalFlowResolver;
import io.gravitee.gateway.flow.condition.evaluation.ExpressionLanguageFlowConditionEvaluator;
import io.gravitee.gateway.flow.condition.evaluation.HttpMethodConditionEvaluator;
import io.gravitee.gateway.flow.condition.evaluation.PathBasedConditionEvaluator;
import io.gravitee.gateway.platform.organization.ReactableOrganization;
import io.gravitee.gateway.platform.organization.manager.OrganizationManager;
import java.util.Collections;
import java.util.List;

public class OrganizationFlowResolver
extends ConditionalFlowResolver {
    private final OrganizationManager organizationManager;

    public OrganizationFlowResolver(OrganizationManager organizationManager) {
        super((ConditionEvaluator)new CompositeConditionEvaluator(new ConditionEvaluator[]{new HttpMethodConditionEvaluator(), new PathBasedConditionEvaluator(), new ExpressionLanguageFlowConditionEvaluator()}));
        this.organizationManager = organizationManager;
    }

    protected List<Flow> resolve0(ExecutionContext context) {
        ReactableOrganization reactableOrganization = this.organizationManager.getOrganization((String)context.getAttribute("gravitee.attribute.organization"));
        if (reactableOrganization != null) {
            return reactableOrganization.getFlows() != null ? reactableOrganization.getFlows() : Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

