/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.platform.organization.flow;

import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.FlowStage;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.core.processor.EmptyStreamableProcessor;
import io.gravitee.gateway.core.processor.StreamableProcessor;
import io.gravitee.gateway.core.processor.chain.DefaultStreamableProcessorChain;
import io.gravitee.gateway.flow.FlowPolicyResolverFactory;
import io.gravitee.gateway.flow.FlowProvider;
import io.gravitee.gateway.flow.FlowResolver;
import io.gravitee.gateway.flow.policy.PolicyChainFactory;
import io.gravitee.gateway.platform.organization.policy.OrganizationPolicyChainFactoryManager;
import io.gravitee.gateway.policy.StreamType;
import io.gravitee.gateway.policy.impl.OrderedPolicyChain;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationFlowProvider
implements FlowProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrganizationFlowProvider.class);
    private final StreamType streamType;
    private final FlowResolver flowResolver;
    private final OrganizationPolicyChainFactoryManager organizationPolicyChainFactoryManager;
    private final FlowPolicyResolverFactory flowPolicyResolverFactory;

    public StreamableProcessor<ExecutionContext, Buffer> provide(ExecutionContext context) {
        List flows = this.flowResolver.resolve(context);
        if (flows != null && !flows.isEmpty()) {
            ArrayList<StreamableProcessor> chain = new ArrayList<StreamableProcessor>(flows.size());
            String organizationId = (String)context.getAttribute("gravitee.attribute.organization");
            PolicyChainFactory policyChainFactory = this.organizationPolicyChainFactoryManager.get(organizationId);
            if (policyChainFactory != null) {
                for (Flow flow : flows) {
                    flow.setStage(FlowStage.PLATFORM);
                    chain.add(policyChainFactory.create(this.flowPolicyResolverFactory.create(flow).resolve(this.streamType, context), this.streamType, context, policies -> OrderedPolicyChain.create((List)policies, (ExecutionContext)context)));
                }
            } else {
                log.warn(String.format("No OrganizationReactor has been registered for organization '%s' while there are resolved flows.", organizationId));
            }
            return new DefaultStreamableProcessorChain(chain);
        }
        return new EmptyStreamableProcessor();
    }

    @Generated
    public OrganizationFlowProvider(StreamType streamType, FlowResolver flowResolver, OrganizationPolicyChainFactoryManager organizationPolicyChainFactoryManager, FlowPolicyResolverFactory flowPolicyResolverFactory) {
        this.streamType = streamType;
        this.flowResolver = flowResolver;
        this.organizationPolicyChainFactoryManager = organizationPolicyChainFactoryManager;
        this.flowPolicyResolverFactory = flowPolicyResolverFactory;
    }
}

