/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.platform.organization;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.gravitee.definition.model.FlowMode;
import io.gravitee.definition.model.Organization;
import io.gravitee.definition.model.Policy;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.Step;
import io.gravitee.gateway.reactor.Reactable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public class ReactableOrganization
implements Reactable,
Serializable {
    private Organization definition;
    private boolean enabled;
    private Date deployedAt;

    public ReactableOrganization(Organization organization) {
        this.definition = Objects.requireNonNull(organization);
        this.deployedAt = new Date();
        this.enabled = true;
    }

    public boolean enabled() {
        return this.isEnabled();
    }

    public <D> Set<D> dependencies(Class<D> type) {
        if (Policy.class.equals(type)) {
            return this.policies();
        }
        return Set.of();
    }

    private Set<Policy> policies() {
        HashSet<Policy> policies = new HashSet<Policy>();
        if (this.definition.getFlows() != null) {
            this.definition.getFlows().forEach(flow -> {
                policies.addAll(this.getPolicies(flow.getPre()));
                policies.addAll(this.getPolicies(flow.getPost()));
            });
        }
        return policies;
    }

    private Collection<Policy> getPolicies(List<Step> flowStep) {
        if (flowStep == null || flowStep.isEmpty()) {
            return Collections.emptyList();
        }
        return flowStep.stream().map(step -> {
            Policy policy = new Policy();
            policy.setName(step.getPolicy());
            policy.setConfiguration(step.getConfiguration());
            return policy;
        }).toList();
    }

    @JsonIgnore
    public String getId() {
        return this.definition.getId();
    }

    @JsonIgnore
    public String getName() {
        return this.definition.getName();
    }

    @JsonIgnore
    public List<Flow> getFlows() {
        return this.definition.getFlows();
    }

    @JsonIgnore
    public void setFlows(List<Flow> flows) {
        this.definition.setFlows(flows);
    }

    @JsonIgnore
    public FlowMode getFlowMode() {
        return this.definition.getFlowMode();
    }

    @Generated
    public ReactableOrganization() {
    }

    @Generated
    public Organization getDefinition() {
        return this.definition;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public Date getDeployedAt() {
        return this.deployedAt;
    }

    @Generated
    public void setDefinition(Organization definition) {
        this.definition = definition;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setDeployedAt(Date deployedAt) {
        this.deployedAt = deployedAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReactableOrganization)) {
            return false;
        }
        ReactableOrganization other = (ReactableOrganization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Organization this$definition = this.getDefinition();
        Organization other$definition = other.getDefinition();
        if (this$definition == null ? other$definition != null : !this$definition.equals(other$definition)) {
            return false;
        }
        Date this$deployedAt = this.getDeployedAt();
        Date other$deployedAt = other.getDeployedAt();
        return !(this$deployedAt == null ? other$deployedAt != null : !((Object)this$deployedAt).equals(other$deployedAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReactableOrganization;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Organization $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : $definition.hashCode());
        Date $deployedAt = this.getDeployedAt();
        result = result * 59 + ($deployedAt == null ? 43 : ((Object)$deployedAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReactableOrganization(definition=" + this.getDefinition() + ", enabled=" + this.isEnabled() + ", deployedAt=" + this.getDeployedAt() + ")";
    }
}

