/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.platform.spring;

import io.gravitee.common.event.EventManager;
import io.gravitee.gateway.core.classloader.DefaultClassLoader;
import io.gravitee.gateway.core.component.ComponentProvider;
import io.gravitee.gateway.flow.FlowPolicyResolverFactory;
import io.gravitee.gateway.flow.FlowResolver;
import io.gravitee.gateway.platform.organization.event.OrganizationEventListener;
import io.gravitee.gateway.platform.organization.flow.OrganizationFlowResolver;
import io.gravitee.gateway.platform.organization.manager.DefaultOrganizationManager;
import io.gravitee.gateway.platform.organization.manager.OrganizationManager;
import io.gravitee.gateway.platform.organization.policy.V3OrganizationPolicyChainFactoryManager;
import io.gravitee.gateway.platform.organization.providers.OnRequestPlatformPolicyChainProvider;
import io.gravitee.gateway.platform.organization.providers.OnResponsePlatformPolicyChainProvider;
import io.gravitee.gateway.platform.organization.reactor.V3OrganizationReactorFactory;
import io.gravitee.gateway.policy.PolicyFactoryCreator;
import io.gravitee.gateway.reactive.platform.organization.policy.DefaultPlatformPolicyChainFactoryManager;
import io.gravitee.gateway.reactive.platform.organization.policy.OrganizationPolicyChainFactoryManager;
import io.gravitee.gateway.reactive.platform.organization.reactor.DefaultOrganizationReactorFactory;
import io.gravitee.gateway.reactive.platform.organization.reactor.OrganizationReactorFactory;
import io.gravitee.gateway.reactive.platform.organization.reactor.OrganizationReactorRegistry;
import io.gravitee.gateway.reactive.policy.PolicyFactory;
import io.gravitee.plugin.policy.PolicyClassLoaderFactory;
import io.gravitee.plugin.resource.ResourceClassLoaderFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PlatformConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${classloader.legacy.enabled:false}")
    private boolean classLoaderLegacyMode;

    @Bean
    public OrganizationManager organizationManager(EventManager eventManager) {
        return new DefaultOrganizationManager(eventManager);
    }

    @Bean
    public OrganizationReactorFactory v3OrganizationReactorFactory(DefaultClassLoader classLoader, PolicyFactoryCreator factoryCreator, PolicyClassLoaderFactory policyClassLoaderFactory, ComponentProvider componentProvider, ResourceClassLoaderFactory resourceClassLoaderFactory) {
        return new V3OrganizationReactorFactory(this.classLoaderLegacyMode, classLoader, this.applicationContext, factoryCreator, policyClassLoaderFactory, componentProvider, resourceClassLoaderFactory);
    }

    @Bean
    public OrganizationReactorRegistry v3OrganizationReactorRegistry(@Qualifier(value="v3OrganizationReactorFactory") OrganizationReactorFactory organizationReactorFactory) {
        return new OrganizationReactorRegistry(organizationReactorFactory);
    }

    @Bean
    public io.gravitee.gateway.platform.organization.policy.OrganizationPolicyChainFactoryManager v3PlatformPolicyChainFactoryManager(@Qualifier(value="v3OrganizationReactorRegistry") OrganizationReactorRegistry organizationReactorRegistry) {
        return new V3OrganizationPolicyChainFactoryManager(organizationReactorRegistry);
    }

    @Bean
    public OrganizationFlowResolver organizationFlowResolver(OrganizationManager organizationManager) {
        return new OrganizationFlowResolver(organizationManager);
    }

    @Bean
    public OnRequestPlatformPolicyChainProvider onRequestPlatformPolicyChainProvider(OrganizationFlowResolver organizationFlowResolver, io.gravitee.gateway.platform.organization.policy.OrganizationPolicyChainFactoryManager v3OrganizationPolicyChainFactoryManager) {
        return new OnRequestPlatformPolicyChainProvider((FlowResolver)organizationFlowResolver, v3OrganizationPolicyChainFactoryManager, new FlowPolicyResolverFactory());
    }

    @Bean
    public OnResponsePlatformPolicyChainProvider onResponsePlatformPolicyChainProvider(OrganizationFlowResolver organizationFlowResolver, io.gravitee.gateway.platform.organization.policy.OrganizationPolicyChainFactoryManager v3OrganizationPolicyChainFactoryManager) {
        return new OnResponsePlatformPolicyChainProvider((FlowResolver)organizationFlowResolver, v3OrganizationPolicyChainFactoryManager, new FlowPolicyResolverFactory());
    }

    @Bean
    public OrganizationReactorFactory organizationReactorFactory(DefaultClassLoader classLoader, PolicyFactory policyFactory, PolicyClassLoaderFactory policyClassLoaderFactory, ComponentProvider componentProvider, io.gravitee.node.api.configuration.Configuration configuration) {
        return new DefaultOrganizationReactorFactory(classLoader, this.applicationContext, policyFactory, policyClassLoaderFactory, componentProvider, configuration);
    }

    @Bean
    public OrganizationReactorRegistry organizationReactorRegistry(@Qualifier(value="organizationReactorFactory") OrganizationReactorFactory organizationReactorFactory) {
        return new OrganizationReactorRegistry(organizationReactorFactory);
    }

    @Bean
    public OrganizationPolicyChainFactoryManager platformPolicyChainFactoryManager(@Qualifier(value="organizationReactorRegistry") OrganizationReactorRegistry organizationReactorRegistry) {
        return new DefaultPlatformPolicyChainFactoryManager(organizationReactorRegistry);
    }

    @Bean
    public OrganizationEventListener organizationEventListener(EventManager eventManager, @Qualifier(value="v3OrganizationReactorRegistry") OrganizationReactorRegistry v3OrganizationReactorRegistry, @Qualifier(value="organizationReactorRegistry") OrganizationReactorRegistry organizationReactorRegistry) {
        return new OrganizationEventListener(eventManager, v3OrganizationReactorRegistry, organizationReactorRegistry);
    }
}

