/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.platform.organization.flow;

import io.gravitee.definition.model.FlowMode;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.gateway.platform.organization.ReactableOrganization;
import io.gravitee.gateway.platform.organization.manager.OrganizationManager;
import io.gravitee.gateway.reactive.api.context.GenericExecutionContext;
import io.gravitee.gateway.reactive.core.condition.ConditionFilter;
import io.gravitee.gateway.reactive.flow.AbstractFlowResolver;
import io.gravitee.gateway.reactive.v4.flow.AbstractBestMatchFlowSelector;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import java.util.Objects;

public class OrganizationFlowResolver
extends AbstractFlowResolver {
    private final String organizationId;
    private final OrganizationManager organizationManager;
    private final AbstractBestMatchFlowSelector<Flow> bestMatchFlowSelector;
    private Flowable<Flow> flows;
    private ReactableOrganization reactableOrganization;

    public OrganizationFlowResolver(String organizationId, OrganizationManager organizationManager, ConditionFilter<Flow> filter, AbstractBestMatchFlowSelector<Flow> bestMatchFlowSelector) {
        super(filter);
        this.organizationId = organizationId;
        this.organizationManager = organizationManager;
        this.bestMatchFlowSelector = bestMatchFlowSelector;
        this.initFlows();
    }

    public Flowable<Flow> resolve(GenericExecutionContext ctx) {
        return super.resolve(ctx).compose(upstream -> {
            if (this.isBestMatch()) {
                return upstream.toList().flatMapMaybe(flowList -> Maybe.fromCallable(() -> (Flow)this.bestMatchFlowSelector.forPath(flowList, ctx.request().pathInfo()))).toFlowable();
            }
            return upstream;
        });
    }

    private boolean isBestMatch() {
        return this.reactableOrganization != null && this.reactableOrganization.getFlowMode() == FlowMode.BEST_MATCH;
    }

    public Flowable<Flow> provideFlows(GenericExecutionContext ctx) {
        this.initFlows();
        return this.flows;
    }

    private void initFlows() {
        ReactableOrganization refreshedReactableOrganization = this.organizationManager.getOrganization(this.organizationId);
        if (this.flows == null || !Objects.equals(this.reactableOrganization, refreshedReactableOrganization)) {
            this.reactableOrganization = refreshedReactableOrganization;
            this.flows = this.provideFlows();
        }
    }

    private Flowable<Flow> provideFlows() {
        if (this.reactableOrganization == null || this.reactableOrganization.getFlows() == null || this.reactableOrganization.getFlows().isEmpty()) {
            return Flowable.empty();
        }
        return Flowable.fromIterable(this.reactableOrganization.getFlows().stream().filter(Flow::isEnabled).toList());
    }
}

