/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.platform;

import io.gravitee.definition.model.Policy;
import io.gravitee.gateway.core.classloader.DefaultClassLoader;
import io.gravitee.gateway.core.component.ComponentProvider;
import io.gravitee.gateway.policy.PolicyConfigurationFactory;
import io.gravitee.gateway.policy.impl.CachedPolicyConfigurationFactory;
import io.gravitee.gateway.reactive.policy.AbstractPolicyManager;
import io.gravitee.gateway.reactive.policy.PolicyFactory;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.policy.PolicyClassLoaderFactory;
import io.gravitee.plugin.policy.PolicyPlugin;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformPolicyManager
extends AbstractPolicyManager {
    private final Logger logger = LoggerFactory.getLogger(PlatformPolicyManager.class);
    private Set<Policy> dependencies;

    public PlatformPolicyManager(DefaultClassLoader classLoader, PolicyFactory policyFactory, PolicyConfigurationFactory policyConfigurationFactory, ConfigurablePluginManager<PolicyPlugin<?>> policyPluginManager, PolicyClassLoaderFactory policyClassLoaderFactory, ComponentProvider componentProvider) {
        super(classLoader, policyFactory, policyConfigurationFactory, policyPluginManager, policyClassLoaderFactory, componentProvider);
    }

    public void setDependencies(Set<Policy> dependencies) {
        this.dependencies = dependencies;
        this.restart();
    }

    private void restart() {
        try {
            this.logger.info("Restart policy manager");
            this.stop();
            this.start();
        }
        catch (Exception e) {
            this.logger.error("Impossible to restart platform policy manager", (Throwable)e);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.policyConfigurationFactory instanceof CachedPolicyConfigurationFactory) {
            ((CachedPolicyConfigurationFactory)this.policyConfigurationFactory).clear();
        }
    }

    protected Set<Policy> dependencies() {
        return this.dependencies;
    }
}

