/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.platform.providers;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.core.processor.StreamableProcessor;
import io.gravitee.gateway.flow.FlowPolicyResolverFactory;
import io.gravitee.gateway.flow.FlowProvider;
import io.gravitee.gateway.flow.FlowResolver;
import io.gravitee.gateway.flow.policy.PolicyChainFactory;
import io.gravitee.gateway.platform.OrganizationFlowProvider;
import io.gravitee.gateway.policy.ConfigurablePolicyChainProvider;
import io.gravitee.gateway.policy.PolicyChainOrder;
import io.gravitee.gateway.policy.StreamType;

public class OnRequestPlatformPolicyChainProvider
extends ConfigurablePolicyChainProvider {
    private final StreamType streamType = StreamType.ON_REQUEST;
    private final FlowResolver flowResolver;
    private final PolicyChainFactory policyChainFactory;
    private FlowPolicyResolverFactory flowPolicyResolverFactory;
    private FlowProvider flowProvider;

    public OnRequestPlatformPolicyChainProvider(FlowResolver flowResolver, PolicyChainFactory policyChainFactory, FlowPolicyResolverFactory flowPolicyResolverFactory) {
        this.flowResolver = flowResolver;
        this.policyChainFactory = policyChainFactory;
        this.flowPolicyResolverFactory = flowPolicyResolverFactory;
    }

    public StreamableProcessor<ExecutionContext, Buffer> provide(ExecutionContext context) {
        return this.getFlowProvider().provide(context);
    }

    private FlowProvider getFlowProvider() {
        if (this.flowProvider == null) {
            this.flowProvider = new OrganizationFlowProvider(this.streamType, this.flowResolver, this.policyChainFactory, this.flowPolicyResolverFactory);
        }
        return this.flowProvider;
    }

    public StreamType getStreamType() {
        return this.streamType;
    }

    public PolicyChainOrder getChainOrder() {
        return PolicyChainOrder.BEFORE_API;
    }
}

