/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.platform;

import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.FlowStage;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.core.processor.EmptyStreamableProcessor;
import io.gravitee.gateway.core.processor.StreamableProcessor;
import io.gravitee.gateway.core.processor.chain.DefaultStreamableProcessorChain;
import io.gravitee.gateway.flow.FlowPolicyResolverFactory;
import io.gravitee.gateway.flow.FlowProvider;
import io.gravitee.gateway.flow.FlowResolver;
import io.gravitee.gateway.flow.policy.PolicyChainFactory;
import io.gravitee.gateway.policy.StreamType;
import io.gravitee.gateway.policy.impl.OrderedPolicyChain;
import java.util.ArrayList;
import java.util.List;

public class OrganizationFlowProvider
implements FlowProvider {
    private final StreamType streamType;
    private final FlowResolver flowResolver;
    private final FlowPolicyResolverFactory flowPolicyResolverFactory;
    private final PolicyChainFactory policyChainFactory;

    public OrganizationFlowProvider(StreamType streamType, FlowResolver flowResolver, PolicyChainFactory policyChainFactory, FlowPolicyResolverFactory flowPolicyResolverFactory) {
        this.streamType = streamType;
        this.flowResolver = flowResolver;
        this.policyChainFactory = policyChainFactory;
        this.flowPolicyResolverFactory = flowPolicyResolverFactory;
    }

    public StreamableProcessor<ExecutionContext, Buffer> provide(ExecutionContext context) {
        List flows = this.flowResolver.resolve(context);
        if (flows != null && !flows.isEmpty()) {
            ArrayList<StreamableProcessor> chain = new ArrayList<StreamableProcessor>(flows.size());
            for (Flow flow : flows) {
                flow.setStage(FlowStage.PLATFORM);
                chain.add(this.policyChainFactory.create(this.flowPolicyResolverFactory.create(flow).resolve(this.streamType, context), this.streamType, context, policies -> OrderedPolicyChain.create((List)policies, (ExecutionContext)context)));
            }
            return new DefaultStreamableProcessorChain(chain);
        }
        return new EmptyStreamableProcessor();
    }
}

