/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.platform.manager.impl;

import io.gravitee.common.event.EventManager;
import io.gravitee.definition.model.Policy;
import io.gravitee.gateway.env.GatewayConfiguration;
import io.gravitee.gateway.platform.Organization;
import io.gravitee.gateway.platform.PlatformPolicyManager;
import io.gravitee.gateway.platform.manager.OrganizationEvent;
import io.gravitee.gateway.platform.manager.OrganizationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OrganizationManagerImpl
implements OrganizationManager {
    private final Logger logger = LoggerFactory.getLogger(OrganizationManagerImpl.class);
    private final io.gravitee.gateway.jupiter.platform.PlatformPolicyManager policyManager;
    private Organization currentOrganization;
    private final PlatformPolicyManager v3policyManager;
    private EventManager eventManager;
    @Autowired
    GatewayConfiguration gatewayConfiguration;

    public OrganizationManagerImpl(io.gravitee.gateway.jupiter.platform.PlatformPolicyManager policyManager, PlatformPolicyManager v3policyManager, EventManager eventManager) {
        this.policyManager = policyManager;
        this.v3policyManager = v3policyManager;
        this.eventManager = eventManager;
    }

    @Override
    public boolean register(Organization organization) {
        if ((this.currentOrganization == null || !this.currentOrganization.equals(organization) || this.currentOrganization.getUpdatedAt() == null || this.currentOrganization.getUpdatedAt().before(organization.getUpdatedAt())) && (this.currentOrganization == null || this.currentOrganization != organization && this.currentOrganization.getUpdatedAt().compareTo(organization.getUpdatedAt()) < 0)) {
            this.logger.info("Register organization {}", (Object)organization);
            this.currentOrganization = organization;
            this.eventManager.publishEvent((Enum)OrganizationEvent.REGISTER, (Object)organization);
            this.policyManager.setDependencies(this.currentOrganization.dependencies(Policy.class));
            this.v3policyManager.setDependencies(this.currentOrganization.dependencies(Policy.class));
            return true;
        }
        return false;
    }

    @Override
    public void unregister(String orgId) {
        this.logger.info("Unregister organization {}", (Object)orgId);
        this.eventManager.publishEvent((Enum)OrganizationEvent.UNREGISTER, (Object)this.currentOrganization);
        this.currentOrganization = null;
    }

    @Override
    public Organization getCurrentOrganization() {
        return this.currentOrganization;
    }
}

