/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.platform;

import io.gravitee.definition.model.Policy;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.Step;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Organization
extends io.gravitee.definition.model.Organization
implements Serializable {
    public Organization(io.gravitee.definition.model.Organization eventOrganization) {
        this.setId(eventOrganization.getId());
        this.setName(eventOrganization.getName());
        this.setDescription(eventOrganization.getDescription());
        this.setDomainRestrictions(eventOrganization.getDomainRestrictions());
        this.setFlowMode(eventOrganization.getFlowMode());
        this.setFlows(eventOrganization.getFlows());
        this.setHrids(eventOrganization.getHrids());
        this.setUpdatedAt(eventOrganization.getUpdatedAt());
    }

    public <D> Set<D> dependencies(Class<D> type) {
        if (Policy.class.equals(type)) {
            return this.policies();
        }
        return Collections.emptySet();
    }

    private Set<Policy> policies() {
        final HashSet<Policy> policies = new HashSet<Policy>();
        if (this.getFlows() != null) {
            this.getFlows().forEach(new Consumer<Flow>(){

                @Override
                public void accept(Flow flow) {
                    policies.addAll(Organization.this.getPolicies(flow.getPre()));
                    policies.addAll(Organization.this.getPolicies(flow.getPost()));
                }
            });
        }
        return policies;
    }

    private Collection<Policy> getPolicies(List<Step> flowStep) {
        if (flowStep == null || flowStep.isEmpty()) {
            return Collections.emptyList();
        }
        return flowStep.stream().map(step -> {
            Policy policy = new Policy();
            policy.setName(step.getPolicy());
            policy.setConfiguration(step.getConfiguration());
            return policy;
        }).collect(Collectors.toList());
    }
}

