/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.platform.spring;

import io.gravitee.gateway.core.classloader.DefaultClassLoader;
import io.gravitee.gateway.core.component.ComponentProvider;
import io.gravitee.gateway.flow.FlowResolver;
import io.gravitee.gateway.flow.policy.PolicyChainFactory;
import io.gravitee.gateway.platform.OrganizationFlowResolver;
import io.gravitee.gateway.platform.PlatformPolicyManager;
import io.gravitee.gateway.platform.manager.OrganizationManager;
import io.gravitee.gateway.platform.manager.impl.OrganizationManagerImpl;
import io.gravitee.gateway.policy.PolicyConfigurationFactory;
import io.gravitee.gateway.policy.PolicyFactory;
import io.gravitee.gateway.policy.PolicyManager;
import io.gravitee.gateway.policy.impl.CachedPolicyConfigurationFactory;
import io.gravitee.gateway.resource.ResourceConfigurationFactory;
import io.gravitee.gateway.resource.ResourceLifecycleManager;
import io.gravitee.gateway.resource.internal.ResourceConfigurationFactoryImpl;
import io.gravitee.gateway.resource.internal.ResourceManagerImpl;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.policy.PolicyClassLoaderFactory;
import io.gravitee.plugin.policy.PolicyPlugin;
import io.gravitee.plugin.resource.ResourceClassLoaderFactory;
import io.gravitee.plugin.resource.ResourcePlugin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;

@Configuration
public class PlatformConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${classloader.legacy.enabled:false}")
    private boolean classLoaderLegacyMode;

    @Bean
    public OrganizationManager organizationManager(PlatformPolicyManager policyManager) {
        return new OrganizationManagerImpl(policyManager);
    }

    @Bean
    public FlowResolver flowResolver(OrganizationManager organizationManager) {
        return new OrganizationFlowResolver(organizationManager);
    }

    @Bean
    public PolicyChainFactory policyChainFactory(PlatformPolicyManager platformPolicyManager) {
        return new PolicyChainFactory((PolicyManager)platformPolicyManager);
    }

    @Bean
    public PlatformPolicyManager platformPolicyManager(PolicyFactory factory, PolicyConfigurationFactory policyConfigurationFactory, PolicyClassLoaderFactory policyClassLoaderFactory, ResourceLifecycleManager resourceLifecycleManager, ComponentProvider componentProvider) {
        String[] beanNamesForType = this.applicationContext.getBeanNamesForType(ResolvableType.forClassWithGenerics(ConfigurablePluginManager.class, (Class[])new Class[]{PolicyPlugin.class}));
        ConfigurablePluginManager cpm = (ConfigurablePluginManager)this.applicationContext.getBean(beanNamesForType[0]);
        return new PlatformPolicyManager(this.classLoaderLegacyMode, (DefaultClassLoader)this.applicationContext.getBean(DefaultClassLoader.class), factory, policyConfigurationFactory, cpm, policyClassLoaderFactory, resourceLifecycleManager, componentProvider);
    }

    @Bean
    public PolicyConfigurationFactory policyConfigurationFactory() {
        return new CachedPolicyConfigurationFactory();
    }

    @Bean
    public ResourceLifecycleManager resourceLifecycleManager(ResourceClassLoaderFactory resourceClassLoaderFactory, ResourceConfigurationFactory resourceConfigurationFactory) {
        String[] beanNamesForType = this.applicationContext.getBeanNamesForType(ResolvableType.forClassWithGenerics(ConfigurablePluginManager.class, (Class[])new Class[]{ResourcePlugin.class}));
        ConfigurablePluginManager cpm = (ConfigurablePluginManager)this.applicationContext.getBean(beanNamesForType[0]);
        return new ResourceManagerImpl(this.classLoaderLegacyMode, (DefaultClassLoader)this.applicationContext.getBean(DefaultClassLoader.class), null, cpm, resourceClassLoaderFactory, resourceConfigurationFactory, this.applicationContext);
    }

    @Bean
    public ResourceConfigurationFactory resourceConfigurationFactory() {
        return new ResourceConfigurationFactoryImpl();
    }
}

