/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.platform.manager.impl;

import io.gravitee.definition.model.Policy;
import io.gravitee.gateway.env.GatewayConfiguration;
import io.gravitee.gateway.platform.Organization;
import io.gravitee.gateway.platform.PlatformPolicyManager;
import io.gravitee.gateway.platform.manager.OrganizationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OrganizationManagerImpl
implements OrganizationManager {
    private final Logger logger = LoggerFactory.getLogger(OrganizationManagerImpl.class);
    private final PlatformPolicyManager policyManager;
    private Organization currentOrganization;
    @Autowired
    GatewayConfiguration gatewayConfiguration;

    public OrganizationManagerImpl(PlatformPolicyManager policyManager) {
        this.policyManager = policyManager;
    }

    @Override
    public boolean register(Organization organization) {
        if (this.currentOrganization == null || !this.currentOrganization.equals(organization) || this.currentOrganization.getUpdatedAt() == null || this.currentOrganization.getUpdatedAt().before(organization.getUpdatedAt())) {
            this.logger.info("Register organization {}", (Object)organization);
            this.currentOrganization = organization;
            this.policyManager.setDependencies(this.currentOrganization.dependencies(Policy.class));
            return true;
        }
        return false;
    }

    @Override
    public void unregister(String orgId) {
        this.logger.info("Unregister organization {}", (Object)orgId);
        this.currentOrganization = null;
    }

    @Override
    public Organization getCurrentOrganization() {
        return this.currentOrganization;
    }
}

